/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.collect.Multimap;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.UtilPacketEvent;
import com.pie.tlatoani.Tablist.SkinTexture.SkinTexture;
import com.pie.tlatoani.Tablist.TabListManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class SimpleTabList {
    private final Player player;
    private final HashMap<String, String> displayNames = new HashMap();
    private final HashMap<String, Integer> latencies = new HashMap();
    private final HashMap<String, SkinTexture> heads = new HashMap();

    public SimpleTabList(Player player) {
        this.player = player;
    }

    private void sendPacket(String id, EnumWrappers.PlayerInfoAction action) {
        int ping = this.latencies.get(id);
        String displayName = this.displayNames.get(id);
        WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)TabListManager.colorStringToJson(displayName));
        UUID uuid = UUID.nameUUIDFromBytes(("MundoSKTabList::" + id).getBytes(TabListManager.utf8));
        SkinTexture icon = this.heads.get(id);
        WrappedGameProfile gameProfile = new WrappedGameProfile(uuid, "");
        if (action == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
            icon.retrieveSkinTextures((Multimap<String, WrappedSignedProperty>)gameProfile.getProperties());
        }
        PlayerInfoData playerInfoData = new PlayerInfoData(gameProfile, ping, EnumWrappers.NativeGameMode.NOT_SET, chatComponent);
        List<PlayerInfoData> playerInfoDatas = Arrays.asList(playerInfoData);
        PacketContainer packetContainer = new PacketContainer(TabListManager.packetType);
        packetContainer.getPlayerInfoDataLists().writeSafely(0, playerInfoDatas);
        packetContainer.getPlayerInfoAction().writeSafely(0, (Object)action);
        try {
            UtilPacketEvent.protocolManager.sendServerPacket(this.player, packetContainer);
        }
        catch (InvocationTargetException e) {
            Mundo.reportException(this, e);
        }
    }

    public void clear() {
        String[] ids = this.displayNames.keySet().toArray(new String[0]);
        for (int i = 0; i < ids.length; ++i) {
            this.deleteTab(ids[i]);
        }
    }

    public boolean tabExists(String id) {
        return this.displayNames.containsKey(id);
    }

    public void createTab(String id, String displayName, Integer ping, SkinTexture head) {
        if (!this.tabExists(id)) {
            ping = Math.max(ping, 0);
            ping = Math.min(ping, 5);
            this.latencies.put(id, ping);
            this.displayNames.put(id, displayName);
            this.heads.put(id, head);
            this.sendPacket(id, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        }
    }

    public void deleteTab(String id) {
        if (this.tabExists(id)) {
            this.sendPacket(id, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            this.displayNames.remove(id);
            this.latencies.remove(id);
            this.heads.remove(id);
        }
    }

    public String getDisplayName(String id) {
        return this.displayNames.get(id);
    }

    public Integer getLatency(String id) {
        return this.latencies.get(id);
    }

    public SkinTexture getHead(String id) {
        return this.heads.get(id);
    }

    public void setDisplayName(String id, String displayName) {
        if (this.tabExists(id)) {
            this.displayNames.put(id, displayName);
            this.sendPacket(id, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
        }
    }

    public void setLatency(String id, Integer ping) {
        if (this.tabExists(id)) {
            this.latencies.put(id, ping);
            this.sendPacket(id, EnumWrappers.PlayerInfoAction.UPDATE_LATENCY);
        }
    }

    public void setHead(String id, SkinTexture icon) {
        if (this.tabExists(id)) {
            this.sendPacket(id, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            this.heads.put(id, icon);
            this.sendPacket(id, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        }
    }
}

