/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Socket2;

import com.pie.tlatoani.Mundo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.bukkit.plugin.Plugin;

public class Socket2 {
    private Socket socket;
    private volatile State state;
    private BufferedWriter writer = null;
    private ArrayList<String> waitingWrites = new ArrayList();

    public Socket2(String host, int port, int timeout) {
        this.socket = new Socket();
        this.state = State.CONNECTING;
        Mundo.scheduler.runTaskAsynchronously((Plugin)Mundo.instance, (Runnable)new SocketConnector(host, port, timeout));
    }

    public Socket2(Socket socket) {
        if (!socket.isConnected()) {
            throw new IllegalArgumentException("The socket " + socket + " should have been already connected prior to use with the Socket2(Socket socket) constructor!");
        }
        this.socket = socket;
        this.state = State.CONNECTED;
        Mundo.scheduler.runTaskAsynchronously((Plugin)Mundo.instance, (Runnable)new SocketReader());
    }

    public String getLocalHost() {
        return this.socket.getLocalAddress().getHostName();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public String getExternalHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public int getExternalPort() {
        return this.socket.getPort();
    }

    public State getState() {
        return this.state;
    }

    public void write(String string) {
        if (this.state == State.CONNECTING) {
            this.waitingWrites.add(string);
        } else if (this.state == State.CONNECTED) {
            if (this.writer == null) {
                try {
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                }
                catch (IOException e) {
                    Mundo.reportException(this, e);
                }
            }
            Mundo.scheduler.runTaskAsynchronously((Plugin)Mundo.instance, (Runnable)new SocketWriter(string));
        }
    }

    public void close() {
        Mundo.scheduler.runTaskAsynchronously((Plugin)Mundo.instance, (Runnable)new SocketCloser());
    }

    private void onRead(String string) {
    }

    private void onConnect() {
        this.state = State.CONNECTED;
        Mundo.scheduler.runTask((Plugin)Mundo.instance, new Runnable(){

            @Override
            public void run() {
                for (String string : Socket2.this.waitingWrites) {
                    Socket2.this.write(string);
                }
            }
        });
        Mundo.scheduler.runTaskAsynchronously((Plugin)Mundo.instance, (Runnable)new SocketReader());
    }

    private void onTimeout() {
        this.state = State.TIMEOUT;
    }

    private void onFailure() {
        this.state = State.FAILURE;
    }

    private void onClose() {
        this.state = State.CLOSED;
    }

    private class SocketCloser
    implements Runnable {
        private SocketCloser() {
        }

        @Override
        public void run() {
            try {
                Socket2.this.socket.close();
            }
            catch (IOException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    private class SocketWriter
    implements Runnable {
        String string;

        SocketWriter(String string) {
            this.string = string;
        }

        @Override
        public void run() {
            try {
                Socket2.this.writer.write(this.string);
                Socket2.this.writer.newLine();
                Socket2.this.writer.flush();
            }
            catch (IOException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    private class SocketReader
    implements Runnable {
        private SocketReader() {
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(Socket2.this.socket.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    Socket2.this.onRead(line);
                }
                Socket2.this.onClose();
            }
            catch (IOException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    private class SocketConnector
    implements Runnable {
        String host;
        int port;
        int timeout;

        SocketConnector(String host, int port, int timeout) {
            this.host = host;
            this.port = port;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                Socket2.this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
                Socket2.this.onConnect();
            }
            catch (SocketTimeoutException e) {
                Socket2.this.onTimeout();
            }
            catch (IOException e) {
                Socket2.this.onFailure();
                Mundo.reportException(this, e);
            }
        }
    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        CLOSED,
        TIMEOUT,
        FAILURE;

    }
}

