/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.pie.tlatoani.Json.API.Json;
import com.pie.tlatoani.Json.API.JsonObject;
import com.pie.tlatoani.Json.API.JsonReader;
import com.pie.tlatoani.Mundo;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;

public class ExprJsonObjectOfPacket
extends SimpleExpression<JsonObject> {
    private Method getObjects = null;
    private PacketInfoGetter getFunction;
    private PacketInfoSetter setFunction;
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    private Class aClass;
    public static Map<String, PacketInfoGetter> getFunctionMap = new HashMap<String, PacketInfoGetter>();
    public static Map<String, PacketInfoSetter> setFunctionMap = new HashMap<String, PacketInfoSetter>();

    protected JsonObject[] get(Event event) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        Mundo.debug((Object)this, "Packet before calling function :" + packet);
        JsonObject result = this.getFunction.apply(packet, ((Number)this.index.getSingle(event)).intValue());
        return new JsonObject[]{result};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<JsonObject> getReturnType() {
        return JsonObject.class;
    }

    public String toString(Event event, boolean b) {
        return "%string% pjson %number% of %packet%";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        String string;
        if (expressions[0] instanceof Literal) {
            string = (String)((Literal)expressions[0]).getSingle();
        } else if (expressions[0] instanceof VariableString) {
            String fullstring = ((VariableString)expressions[0]).toString();
            string = fullstring.substring(1, fullstring.length() - 1);
        } else {
            Skript.error((String)("The string '" + expressions[0] + "' is not a literal string! Only literal strings can be used in the pjson expression!"));
            return false;
        }
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        if (getFunctionMap.containsKey(string.toLowerCase())) {
            this.getFunction = getFunctionMap.get(string.toLowerCase());
            this.setFunction = setFunctionMap.get(string.toLowerCase());
            return true;
        }
        Skript.error((String)("The string " + string + " is not a valid packetinfo!"));
        return false;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        Mundo.debug((Object)this, "Packet before calling function :" + packet);
        this.setFunction.apply(packet, ((Number)this.index.getSingle(event)).intValue(), (JsonObject)delta[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{JsonObject.class});
        }
        return null;
    }

    static {
        getFunctionMap.put("chatcomponent", new PacketInfoGetter(){

            @Override
            public JsonObject apply(PacketContainer packet, Integer index) {
                Mundo.debug((Object)this, "Packet :" + packet);
                Mundo.debug((Object)this, "ChatComponents :" + packet.getChatComponents());
                WrappedChatComponent chatComponent = (WrappedChatComponent)packet.getChatComponents().readSafely(index.intValue());
                String fromjson = chatComponent.getJson();
                Mundo.debug((Object)this, "Fromjson: " + fromjson);
                JsonReader jsonReader = Json.createReader(new StringReader(fromjson));
                JsonObject tojson = jsonReader.readObject();
                Mundo.debug((Object)this, "Tojson " + tojson);
                return tojson;
            }
        });
        setFunctionMap.put("chatcomponent", new PacketInfoSetter(){

            @Override
            public void apply(PacketContainer packet, Integer index, JsonObject value) {
                WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)value.toString());
                packet.getChatComponents().writeSafely(index.intValue(), (Object)chatComponent);
            }
        });
    }

    @FunctionalInterface
    public static interface PacketInfoSetter {
        public void apply(PacketContainer var1, Integer var2, JsonObject var3);
    }

    @FunctionalInterface
    public static interface PacketInfoGetter {
        public JsonObject apply(PacketContainer var1, Integer var2);
    }
}

