/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Json.Implementation;

import com.pie.tlatoani.Json.API.stream.JsonGenerator;
import com.pie.tlatoani.Json.API.stream.JsonGeneratorFactory;
import com.pie.tlatoani.Json.Implementation.JsonGeneratorImpl;
import com.pie.tlatoani.Json.Implementation.JsonPrettyGeneratorImpl;
import com.pie.tlatoani.Json.Implementation.api.BufferPool;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;

class JsonGeneratorFactoryImpl
implements JsonGeneratorFactory {
    private final boolean prettyPrinting;
    private final Map<String, ?> config;
    private final BufferPool bufferPool;

    JsonGeneratorFactoryImpl(Map<String, ?> config, boolean prettyPrinting, BufferPool bufferPool) {
        this.config = config;
        this.prettyPrinting = prettyPrinting;
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(writer, this.bufferPool) : new JsonGeneratorImpl(writer, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(out, this.bufferPool) : new JsonGeneratorImpl(out, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out, Charset charset) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(out, charset, this.bufferPool) : new JsonGeneratorImpl(out, charset, this.bufferPool);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

