/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Json.API.spi;

import com.pie.tlatoani.Json.API.JsonArrayBuilder;
import com.pie.tlatoani.Json.API.JsonBuilderFactory;
import com.pie.tlatoani.Json.API.JsonException;
import com.pie.tlatoani.Json.API.JsonObjectBuilder;
import com.pie.tlatoani.Json.API.JsonReader;
import com.pie.tlatoani.Json.API.JsonReaderFactory;
import com.pie.tlatoani.Json.API.JsonWriter;
import com.pie.tlatoani.Json.API.JsonWriterFactory;
import com.pie.tlatoani.Json.API.stream.JsonGenerator;
import com.pie.tlatoani.Json.API.stream.JsonGeneratorFactory;
import com.pie.tlatoani.Json.API.stream.JsonParser;
import com.pie.tlatoani.Json.API.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class JsonProvider {
    private static final String DEFAULT_PROVIDER = "com.pie.tlatoani.Json.Implementation.JsonProviderImpl";

    protected JsonProvider() {
    }

    public static JsonProvider provider() {
        ServiceLoader<JsonProvider> loader = ServiceLoader.load(JsonProvider.class);
        Iterator<JsonProvider> it = loader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        try {
            Class<?> clazz = Class.forName(DEFAULT_PROVIDER);
            return (JsonProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new JsonException("Provider com.pie.tlatoani.Json.Implementation.JsonProviderImpl not found", x);
        }
        catch (Exception x) {
            throw new JsonException("Provider com.pie.tlatoani.Json.Implementation.JsonProviderImpl could not be instantiated: " + x, x);
        }
    }

    public abstract JsonParser createParser(Reader var1);

    public abstract JsonParser createParser(InputStream var1);

    public abstract JsonParserFactory createParserFactory(Map<String, ?> var1);

    public abstract JsonGenerator createGenerator(Writer var1);

    public abstract JsonGenerator createGenerator(OutputStream var1);

    public abstract JsonGeneratorFactory createGeneratorFactory(Map<String, ?> var1);

    public abstract JsonReader createReader(Reader var1);

    public abstract JsonReader createReader(InputStream var1);

    public abstract JsonWriter createWriter(Writer var1);

    public abstract JsonWriter createWriter(OutputStream var1);

    public abstract JsonWriterFactory createWriterFactory(Map<String, ?> var1);

    public abstract JsonReaderFactory createReaderFactory(Map<String, ?> var1);

    public abstract JsonObjectBuilder createObjectBuilder();

    public abstract JsonArrayBuilder createArrayBuilder();

    public abstract JsonBuilderFactory createBuilderFactory(Map<String, ?> var1);
}

