/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.ObjectEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Event;

public class ExprAllPacketTypes
extends SimpleExpression<PacketType> {
    private static List<PacketType> listToConvert = new ArrayList<PacketType>();
    private static PacketType[] returnArray;
    private static Map<String, PacketType> nametoptype;
    private static Map<PacketType, String> ptypetoname;
    private static Map<PacketType, Boolean> ptypetoboolean;

    private static void addPacketTypes(ObjectEnum<PacketType> packetTypes, String prefix, Boolean isServer) {
        for (PacketType current : packetTypes) {
            listToConvert.add(current);
            String fullname = prefix + "_" + (isServer != false ? "server" : "client") + "_" + current.name().toLowerCase();
            nametoptype.put(fullname, current);
            ptypetoname.put(current, fullname);
            ptypetoboolean.put(current, isServer);
        }
    }

    public static PacketType fromString(String s) {
        return nametoptype.get(s);
    }

    public static String PacketTypeToString(PacketType ptype) {
        return ptypetoname.get(ptype);
    }

    public static Boolean isServer(PacketType packetType) {
        return ptypetoboolean.get(packetType);
    }

    public PacketType[] get(Event event) {
        return returnArray;
    }

    public Iterator<PacketType> iterator(Event event) {
        return listToConvert.iterator();
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends PacketType> getReturnType() {
        return PacketType.class;
    }

    public String toString(Event event, boolean b) {
        return "all packettypes";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        return true;
    }

    static {
        nametoptype = new HashMap<String, PacketType>();
        ptypetoname = new HashMap<PacketType, String>();
        ptypetoboolean = new HashMap<PacketType, Boolean>();
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Play.Server.getInstance(), "play", true);
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Play.Client.getInstance(), "play", false);
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Handshake.Server.getInstance(), "handshake", true);
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Handshake.Client.getInstance(), "handshake", false);
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Login.Server.getInstance(), "login", true);
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Login.Client.getInstance(), "login", false);
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Status.Server.getInstance(), "status", true);
        ExprAllPacketTypes.addPacketTypes((ObjectEnum<PacketType>)PacketType.Status.Client.getInstance(), "status", false);
        returnArray = listToConvert.toArray(new PacketType[0]);
    }
}

