/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Json.Implementation;

import com.pie.tlatoani.Json.API.JsonArrayBuilder;
import com.pie.tlatoani.Json.API.JsonBuilderFactory;
import com.pie.tlatoani.Json.API.JsonObjectBuilder;
import com.pie.tlatoani.Json.API.JsonReader;
import com.pie.tlatoani.Json.API.JsonReaderFactory;
import com.pie.tlatoani.Json.API.JsonWriter;
import com.pie.tlatoani.Json.API.JsonWriterFactory;
import com.pie.tlatoani.Json.API.spi.JsonProvider;
import com.pie.tlatoani.Json.API.stream.JsonGenerator;
import com.pie.tlatoani.Json.API.stream.JsonGeneratorFactory;
import com.pie.tlatoani.Json.API.stream.JsonParser;
import com.pie.tlatoani.Json.API.stream.JsonParserFactory;
import com.pie.tlatoani.Json.Implementation.BufferPoolImpl;
import com.pie.tlatoani.Json.Implementation.JsonArrayBuilderImpl;
import com.pie.tlatoani.Json.Implementation.JsonBuilderFactoryImpl;
import com.pie.tlatoani.Json.Implementation.JsonGeneratorFactoryImpl;
import com.pie.tlatoani.Json.Implementation.JsonGeneratorImpl;
import com.pie.tlatoani.Json.Implementation.JsonObjectBuilderImpl;
import com.pie.tlatoani.Json.Implementation.JsonParserFactoryImpl;
import com.pie.tlatoani.Json.Implementation.JsonParserImpl;
import com.pie.tlatoani.Json.Implementation.JsonReaderFactoryImpl;
import com.pie.tlatoani.Json.Implementation.JsonReaderImpl;
import com.pie.tlatoani.Json.Implementation.JsonWriterFactoryImpl;
import com.pie.tlatoani.Json.Implementation.JsonWriterImpl;
import com.pie.tlatoani.Json.Implementation.api.BufferPool;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JsonProviderImpl
extends JsonProvider {
    private final BufferPool bufferPool = new BufferPoolImpl();

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return new JsonGeneratorImpl(writer, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return new JsonGeneratorImpl(out, this.bufferPool);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return new JsonParserImpl(reader, this.bufferPool);
    }

    @Override
    public JsonParser createParser(InputStream in) {
        return new JsonParserImpl(in, this.bufferPool);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonParserFactoryImpl(pool);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        BufferPool pool;
        boolean prettyPrinting;
        Map<String, Object> providerConfig;
        if (config == null) {
            providerConfig = Collections.emptyMap();
            prettyPrinting = false;
            pool = this.bufferPool;
        } else {
            providerConfig = new HashMap();
            prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
            if (prettyPrinting) {
                providerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((pool = (BufferPool)config.get(BufferPool.class.getName())) != null) {
                providerConfig.put(BufferPool.class.getName(), pool);
            } else {
                pool = this.bufferPool;
            }
            providerConfig = Collections.unmodifiableMap(providerConfig);
        }
        return new JsonGeneratorFactoryImpl(providerConfig, prettyPrinting, pool);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(reader, this.bufferPool);
    }

    @Override
    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(in, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        return new JsonWriterImpl(out, this.bufferPool);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        BufferPool pool;
        boolean prettyPrinting;
        Map<String, Object> providerConfig;
        if (config == null) {
            providerConfig = Collections.emptyMap();
            prettyPrinting = false;
            pool = this.bufferPool;
        } else {
            providerConfig = new HashMap();
            prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
            if (prettyPrinting) {
                providerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((pool = (BufferPool)config.get(BufferPool.class.getName())) != null) {
                providerConfig.put(BufferPool.class.getName(), pool);
            } else {
                pool = this.bufferPool;
            }
            providerConfig = Collections.unmodifiableMap(providerConfig);
        }
        return new JsonWriterFactoryImpl(providerConfig, prettyPrinting, pool);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonReaderFactoryImpl(pool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonBuilderFactoryImpl(pool);
    }

    static boolean isPrettyPrintingEnabled(Map<String, ?> config) {
        return config.containsKey("javax.json.stream.JsonGenerator.prettyPrinting");
    }
}

