/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Core.Static;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class Reflection {
    private static String OBC_PREFIX = Bukkit.getServer().getClass().getPackage().getName();
    private static String NMS_PREFIX = OBC_PREFIX.replace("org.bukkit.craftbukkit", "net.minecraft.server");
    private static String VERSION = OBC_PREFIX.replace("org.bukkit.craftbukkit", "").replace(".", "");
    public static Object NMS_SERVER = null;
    private static Pattern MATCH_VARIABLE;

    public static Object getStaticField(Class<?> location, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = location.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(null);
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean methodExists(Class c, String methodName, Class ... params) {
        try {
            c.getMethod(methodName, params);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Reflection() {
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType) {
        return Reflection.getField(target, name, fieldType, 0);
    }

    public static <T> FieldAccessor<T> getField(String className, String name, Class<T> fieldType) {
        return Reflection.getField(Reflection.getClass(className), name, fieldType, 0);
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, Class<T> fieldType, int index) {
        return Reflection.getField(target, null, fieldType, index);
    }

    public static <T> FieldAccessor<T> getField(String className, Class<T> fieldType, int index) {
        return Reflection.getField(Reflection.getClass(className), fieldType, index);
    }

    private static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType, int index) {
        for (final Field field : target.getDeclaredFields()) {
            if (name != null && !field.getName().equals(name) || !fieldType.isAssignableFrom(field.getType()) || index-- > 0) continue;
            field.setAccessible(true);
            return new FieldAccessor<T>(){

                @Override
                public T get(Object target) {
                    try {
                        return field.get(target);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public boolean hasField(Object target) {
                    return field.getDeclaringClass().isAssignableFrom(target.getClass());
                }
            };
        }
        if (target.getSuperclass() != null) {
            return Reflection.getField(target.getSuperclass(), name, fieldType, index);
        }
        throw new IllegalArgumentException("Cannot find field with type " + fieldType);
    }

    public static MethodInvoker getMethod(String className, String methodName, Class<?> ... params) {
        return Reflection.getTypedMethod(Reflection.getClass(className), methodName, null, params);
    }

    public static MethodInvoker getMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        return Reflection.getTypedMethod(clazz, methodName, null, params);
    }

    public static MethodInvoker getTypedMethod(Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... params) {
        for (final Method method : clazz.getDeclaredMethods()) {
            if (methodName != null && !method.getName().equals(methodName) || returnType != null && !method.getReturnType().equals(returnType) || !Arrays.equals(method.getParameterTypes(), params)) continue;
            method.setAccessible(true);
            return new MethodInvoker(){

                @Override
                public Object invoke(Object target, Object ... arguments) {
                    try {
                        return method.invoke(target, arguments);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot invoke method " + method, e);
                    }
                }
            };
        }
        if (clazz.getSuperclass() != null) {
            return Reflection.getMethod(clazz.getSuperclass(), methodName, params);
        }
        throw new IllegalStateException(String.format("Unable to find method %s (%s).", methodName, Arrays.asList(params)));
    }

    public static ConstructorInvoker getConstructor(String className, Class<?> ... params) {
        return Reflection.getConstructor(Reflection.getClass(className), params);
    }

    public static ConstructorInvoker getConstructor(Class<?> clazz, Class<?> ... params) {
        for (final Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!Arrays.equals(constructor.getParameterTypes(), params)) continue;
            constructor.setAccessible(true);
            return new ConstructorInvoker(){

                @Override
                public Object invoke(Object ... arguments) {
                    try {
                        return constructor.newInstance(arguments);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot invoke constructor " + constructor, e);
                    }
                }
            };
        }
        throw new IllegalStateException(String.format("Unable to find constructor for %s (%s).", clazz, Arrays.asList(params)));
    }

    public static Class<Object> getUntypedClass(String lookupName) {
        Class<Object> clazz = Reflection.getClass(lookupName);
        return clazz;
    }

    public static Class<?> getClass(String lookupName) {
        return Reflection.getCanonicalClass(Reflection.expandVariables(lookupName));
    }

    public static Class<?> getMinecraftClass(String name) {
        return Reflection.getCanonicalClass(NMS_PREFIX + "." + name);
    }

    public static Class<?> getCraftBukkitClass(String name) {
        return Reflection.getCanonicalClass(OBC_PREFIX + "." + name);
    }

    private static Class<?> getCanonicalClass(String canonicalName) {
        try {
            return Class.forName(canonicalName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find " + canonicalName, e);
        }
    }

    private static String expandVariables(String name) {
        StringBuffer output = new StringBuffer();
        Matcher matcher = MATCH_VARIABLE.matcher(name);
        while (matcher.find()) {
            String variable = matcher.group(1);
            String replacement = "";
            if ("nms".equalsIgnoreCase(variable)) {
                replacement = NMS_PREFIX;
            } else if ("obc".equalsIgnoreCase(variable)) {
                replacement = OBC_PREFIX;
            } else if ("version".equalsIgnoreCase(variable)) {
                replacement = VERSION;
            } else {
                throw new IllegalArgumentException("Unknown variable: " + variable);
            }
            if (replacement.length() > 0 && matcher.end() < name.length() && name.charAt(matcher.end()) != '.') {
                replacement = replacement + ".";
            }
            matcher.appendReplacement(output, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    static {
        try {
            NMS_SERVER = Reflection.getTypedMethod(Reflection.getCraftBukkitClass("CraftServer"), "getHandle", Reflection.getMinecraftClass("DedicatedPlayerList"), new Class[0]).invoke(Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MATCH_VARIABLE = Pattern.compile("\\{([^\\}]+)\\}");
    }

    public static interface FieldAccessor<T> {
        public T get(Object var1);

        public void set(Object var1, Object var2);

        public boolean hasField(Object var1);
    }

    public static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2);
    }

    public static interface ConstructorInvoker {
        public Object invoke(Object ... var1);
    }
}

