/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.sqlibrary.misc;

import com.morkaz.morkazsk.MorkazSk;
import java.util.ArrayList;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AsyncMysqlScheduler {
    private MorkazSk main;
    private ArrayList<Runnable> runnableList = new ArrayList();
    private Boolean processing = false;
    private BukkitTask schedulerTask;

    public AsyncMysqlScheduler(MorkazSk main) {
        this.main = main;
    }

    public void cancelSchedulerTask() {
        this.schedulerTask.cancel();
    }

    public BukkitTask getSchedulerTask() {
        return this.schedulerTask;
    }

    public void reloadScheduler() {
        this.schedulerTask.cancel();
        this.runnableList.clear();
        this.processing = false;
        this.startScheduler();
    }

    public void scheduleRunnable(final Runnable runnable) {
        if (!this.processing.booleanValue()) {
            this.runnableList.add(runnable);
        } else {
            this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    AsyncMysqlScheduler.this.runnableList.add(runnable);
                }
            }, 1L);
        }
    }

    public BukkitTask startScheduler() {
        this.schedulerTask = new BukkitRunnable(){

            public void run() {
                if (!AsyncMysqlScheduler.this.processing.booleanValue()) {
                    AsyncMysqlScheduler.this.processing = true;
                    ArrayList copiedRunnableList = (ArrayList)AsyncMysqlScheduler.this.runnableList.clone();
                    AsyncMysqlScheduler.this.runnableList.clear();
                    for (Runnable runnable : copiedRunnableList) {
                        if (runnable == null) continue;
                        try {
                            runnable.run();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    AsyncMysqlScheduler.this.processing = false;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.main, 0L, 2L);
        return this.schedulerTask;
    }
}

