/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxperms;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.Morkaz.MoxPerms.MoxPerms;
import com.morkaz.morkazsk.managers.RegisterManager;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Player Has Player (Own) Permission")
@Description(value={"Checks if player has player permission (that is added directly to him).", "Works only with plugin \"MoxPerms\"."})
@Examples(value={"on chat:", "\tif player does not have player permission \"permission.chat\":", "\t\tcancel event", "\t\tsend \"&cYou have to purcharse chat access to type something on chat on this server!\" to player"})
@Since(value="1.2")
public class CondPlayerHasPlayerPermission
extends Condition {
    private Expression<String> permissionExpr;
    private Expression<?> playerExpr;
    int pattern = 0;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = pattern;
        this.playerExpr = expressions[0];
        this.permissionExpr = expressions[1];
        this.setNegated(pattern == 1 || pattern == 3);
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0 || this.pattern == 2) {
            return this.playerExpr.toString(event, debug) + " has player permission " + this.permissionExpr.toString(event, debug);
        }
        return this.playerExpr.toString(event, debug) + " has not player permission " + this.permissionExpr.toString(event, debug);
    }

    public boolean check(Event event) {
        Object playerObject = this.playerExpr.getSingle(event);
        String permission = (String)this.permissionExpr.getSingle(event);
        if (playerObject != null && permission != null) {
            if (playerObject instanceof Player) {
                Boolean hasPerm = MoxPerms.getIntance().getPermissionManager().getPermissions(((Player)playerObject).getName().toLowerCase()).contains(permission);
                return this.isNegated() ? !hasPerm.booleanValue() : hasPerm;
            }
            if (playerObject instanceof String) {
                Boolean hasPerm = MoxPerms.getIntance().getPermissionManager().getPermissions(((String)playerObject).toLowerCase()).contains(permission);
                return this.isNegated() ? !hasPerm.booleanValue() : hasPerm;
            }
        }
        return this.isNegated();
    }

    static {
        RegisterManager.registerCondition(CondPlayerHasPlayerPermission.class, "[morkazsk] [the] %player% (has|is having) player permission %string%", "[morkazsk] [the] %player% (hasn(t|'t)|is((nt|n't)| not) having) player permission %string%", "[morkazsk] [the] %string% (has|is having) player permission %string%", "[morkazsk] [the] %string% (hasn(t|'t)|is((nt|n't)| not) having) player permission %string%");
    }
}

