/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxData;
import org.bukkit.event.Event;

@Name(value="Remove Mox Pair from Mox Data")
@Description(value={"This effect will remove mox pair from chain of mox data", "Full tutorial: https://github.com/MorkaZ/MorkazSk/wiki/Mox-Data-tutorial"})
@Examples(value={"remove pair with key \"my-key\" from {_mox.data}"})
@Since(value="1.1-beta2")
@RequiredPlugins(value={"MoxCore"})
public class EffRemovePairFromDataByKey
extends Effect {
    private Expression<MoxData> moxDataExpr;
    private Expression<String> keysExpr;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.keysExpr = expressions[0];
        this.moxDataExpr = expressions[1];
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "remove " + this.keysExpr.toString(event, debug) + " from " + this.moxDataExpr.toString(event, debug);
    }

    protected void execute(Event e) {
        MoxData moxData = (MoxData)this.moxDataExpr.getSingle(e);
        String[] keys = (String[])this.keysExpr.getArray(e);
        if (moxData != null && keys != null) {
            for (String key : keys) {
                moxData.remove(key);
            }
        }
    }

    static {
        RegisterManager.registerEffect(EffRemovePairFromDataByKey.class, "remove [mox] pair[s] (with|by) key[s] %strings% from %moxdata%");
    }
}

