/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.universal;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.MorkazSk;
import com.morkaz.morkazsk.managers.RegisterManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="All Lines Of File")
@Description(value={"Return all lines of specific file.", "Use %morkazskdir% to get path to plugins/MorkazSk directory."})
@Examples(value={"all file lines of \"%morkazskdir%/myfile.txt\""})
@Since(value="1.2-beta3")
public class ExprLinesOfFile
extends SimpleExpression<String> {
    Expression<String> filePathExpr;

    public boolean isSingle() {
        return false;
    }

    public String toString(Event event, boolean debug) {
        return "all file lines of " + this.filePathExpr.toString(event, debug);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] expressions, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.filePathExpr = expressions[0];
        return true;
    }

    protected String[] get(Event event) {
        String path = (String)this.filePathExpr.getSingle(event);
        if (path != null) {
            path = path.replace("%morkazskdir%", MorkazSk.getInstance().getDataFolder().getPath());
            try {
                List<String> lines = Files.readAllLines(new File(path).toPath(), Charset.defaultCharset());
                return lines.toArray(new String[lines.size()]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return new String[0];
            }
        }
        return new String[0];
    }

    static {
        RegisterManager.registerExpression(ExprLinesOfFile.class, String.class, ExpressionType.SIMPLE, "[morkazsk] [all] file lines of %string%");
    }
}

