/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.universal;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.morkazsk.misc.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Absorption Hearts Of Player")
@Description(value={"Returns number value of absorption hears of player."})
@Examples(value={"set {_absorption} to player's absorption hears", "add 1 to absorption hearts of player"})
@Since(value="1.2-beta3")
public class ExprAbsorptionHeartsOfPlayer
extends SimpleExpression<Number> {
    private Expression<Player> playerExpr;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.playerExpr = expressions[0];
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "morkazsk absorption hears of " + this.playerExpr.toString(event, debug);
    }

    protected Number[] get(Event event) {
        Player player = (Player)this.playerExpr.getSingle(event);
        if (player != null) {
            return new Number[]{this.getAbsorptionHearts(player)};
        }
        return new Number[0];
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Player player = (Player)this.playerExpr.getSingle(event);
        if (player != null) {
            Number num = (Number)delta[0];
            Number numNow = this.getAbsorptionHearts(player);
            if (mode == Changer.ChangeMode.SET) {
                this.setAbsorptionHearts(player, Float.valueOf(num.floatValue()));
            } else if (mode == Changer.ChangeMode.RESET) {
                this.setAbsorptionHearts(player, 0);
            } else if (mode == Changer.ChangeMode.ADD) {
                this.setAbsorptionHearts(player, Float.valueOf(numNow.floatValue() + num.floatValue()));
            } else if (mode == Changer.ChangeMode.REMOVE) {
                this.setAbsorptionHearts(player, Float.valueOf(numNow.floatValue() - num.floatValue()));
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    private Number getAbsorptionHearts(Player player) {
        try {
            Object handle = ReflectionUtil.getHandle(player);
            Float aborption = (Float)handle.getClass().getMethod("getAbsorptionHearts", new Class[0]).invoke(handle, new Object[0]);
            return aborption;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setAbsorptionHearts(Player player, Number number) {
        try {
            Object handle = ReflectionUtil.getHandle(player);
            handle.getClass().getMethod("setAbsorptionHearts", Float.TYPE).invoke(handle, Float.valueOf(number.floatValue()));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        RegisterManager.registerExpression(ExprAbsorptionHeartsOfPlayer.class, Number.class, ExpressionType.SIMPLE, "[morkazsk] absorption heart[s] of %player%", "[morkazsk] %player%'s absorption heart[s]");
    }
}

