/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.effects;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Drop Item At Location")
@Description(value={"This effect is created because Skript does not always want to spawn dropped item.", "Also, Skript's build in effect is very often bugged so this one is just always-working mirror to protect Skript users from troubles."})
@Examples(value={"morkazsk drop item %itemstack% at %location%"})
@Since(value="1.2-beta3")
public class EffDropItem
extends Effect {
    private Expression<Location> locationExpr;
    private Expression<ItemStack> itemExpr;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.itemExpr = expressions[0];
        this.locationExpr = expressions[1];
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "morkazsk drop item " + this.itemExpr.toString(event, debug) + " at " + this.locationExpr.toString(event, debug);
    }

    protected void execute(Event e) {
        ItemStack itemStack = (ItemStack)this.itemExpr.getSingle(e);
        Location location = (Location)this.locationExpr.getSingle(e);
        if (itemStack != null && location != null) {
            location.getWorld().dropItem(location, itemStack);
        }
    }

    static {
        RegisterManager.registerEffect(EffDropItem.class, "[morkazsk] drop item %itemstack% at %location%");
    }
}

