/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.effects;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Name(value="Better Remove Item From Inventory")
@Description(value={"This effect is created because Skript does not always want to remove given item from specific inventory or sometimes it removes wrong item.", "Also, Skript's build in effect is very often bugged so this one is just always-working mirror to protect Skript users from troubles."})
@Examples(value={"morkazsk remove item {mmo::gem.item::%player%} from player's inventory", "remove item 7 of diamonds named \"My Diamond\" from player's inventory"})
@Since(value="1.2-beta3")
public class EffBetterRemoveItemFromInventory
extends Effect {
    private Expression<Inventory> inventoryExpr;
    private Expression<ItemStack> itemExpr;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.itemExpr = expressions[0];
        this.inventoryExpr = expressions[1];
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "morkazsk remove item " + this.itemExpr.toString(event, debug) + " from " + this.inventoryExpr.toString(event, debug);
    }

    protected void execute(Event e) {
        ItemStack itemStack = (ItemStack)this.itemExpr.getSingle(e);
        Inventory inventory = (Inventory)this.inventoryExpr.getSingle(e);
        if (itemStack != null && inventory != null) {
            inventory.removeItem(new ItemStack[]{itemStack});
        }
    }

    static {
        RegisterManager.registerEffect(EffBetterRemoveItemFromInventory.class, "[morkazsk] remove item %itemstack% from %inventory%");
    }
}

