/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Name(value="Entity Having Potion Effect")
@Description(value={"Checks if living entity has applied given potion effect(s). ", "If one of this effects will exist on entity, return will be \"true\"."})
@Examples(value={"on damage:", "\tif attacker has potion effect slow:", "\t\tadd 1 to damage"})
@Since(value="1.2-beta3")
public class CondInventoryContainItem
extends Condition {
    private Expression<Inventory> inventoryExpr;
    private Expression<ItemStack> itemStackExpr;
    int pattern = 0;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = pattern;
        this.inventoryExpr = expressions[0];
        this.itemStackExpr = expressions[1];
        this.setNegated(pattern == 1);
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return this.inventoryExpr.toString(event, debug) + " contains at least " + this.itemStackExpr.toString(event, debug);
        }
        return this.inventoryExpr.toString(event, debug) + " does not contain at least " + this.itemStackExpr.toString(event, debug);
    }

    public boolean check(Event event) {
        Inventory inventory = (Inventory)this.inventoryExpr.getSingle(event);
        ItemStack itemStack = (ItemStack)this.itemStackExpr.getSingle(event);
        if (inventory != null && itemStack != null) {
            for (ItemStack checkItem : inventory.getContents()) {
                if (!checkItem.equals((Object)itemStack)) continue;
                return !this.isNegated();
            }
        }
        return this.isNegated();
    }

    static {
        RegisterManager.registerCondition(CondInventoryContainItem.class, "[morkazsk] %inventory% (has|have|contain[s]) at least %itemstack%", "[morkazsk] %inventory% (hasn(t|'t)|is((nt|n't)| not) having)|(does not|doesn[']t) contain at least %itemstack%");
    }
}

