/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.protocollib;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.morkazsk.misc.ToolBox;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Play Sound for Player")
@Description(value={"Plays sound only to single player."})
@Examples(value={"play sound \"ENTITY_BAT_DEATH\" specifically to player with pitch 2.0 and volume 1.0 #Easier syntax for faster usage", "play sound \"ENTITY_BAT_DEATH\" at location of player with pitch 2.0 and volume 1.0 for player #You can define from where sound will be played"})
@RequiredPlugins(value={"ProtocolLib"})
@Since(value="1.0")
public class EffPlaySoundForPlayer
extends Effect {
    private Expression<String> sound;
    private Expression<Number> pitch;
    private Expression<Number> volume;
    private Expression<Location> location;
    private Expression<Player> player;
    private ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
    int pattern = 0;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.pattern = pattern;
        if (pattern == 0) {
            this.sound = expressions[0];
            this.location = expressions[1];
            this.pitch = expressions[2];
            this.volume = expressions[3];
            this.player = expressions[4];
        } else {
            this.sound = expressions[0];
            this.player = expressions[1];
            this.pitch = expressions[2];
            this.volume = expressions[3];
        }
        return true;
    }

    public String toString(Event event, boolean debug) {
        if (this.pattern == 0) {
            return "play sound " + this.sound.toString(event, debug) + " at location " + this.location.toString(event, debug) + " with pitch " + this.pitch.toString(event, debug) + " and volume " + this.volume.toString(event, debug) + " for " + this.player.toString(event, debug);
        }
        return "play sound " + this.sound.toString(event, debug) + " specifically to " + this.player.toString(event, debug) + " with pitch " + this.pitch.toString(event, debug) + " and volume " + this.volume.toString(event, debug);
    }

    protected void execute(Event e) {
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.NAMED_SOUND_EFFECT);
        if (this.sound.getSingle(e) != null && this.pitch.getSingle(e) != null && this.volume.getSingle(e) != null && this.player.getSingle(e) != null) {
            Location soundLocation;
            if (!ToolBox.enumContains(Sound.class, (String)this.sound.getSingle(e)).booleanValue()) {
                Skript.warning((String)("[MorkazSk] Given sound name: \"" + (String)this.sound.getSingle(e) + "\" does not exist in bukkit sound list! Use Bukkit enum names!"));
                return;
            }
            if (this.location != null) {
                soundLocation = this.location.getSingle(e) == null ? (Location)this.location.getSingle(e) : ((Player)this.player.getSingle(e)).getLocation();
                packet.getSoundCategories().write(0, (Object)EnumWrappers.SoundCategory.PLAYERS);
                packet.getSoundEffects().write(0, (Object)Sound.valueOf((String)((String)this.sound.getSingle(e))));
                packet.getIntegers().write(0, (Object)((int)(soundLocation.getX() * 8.0)));
                packet.getIntegers().write(1, (Object)((int)(soundLocation.getY() * 8.0)));
                packet.getIntegers().write(2, (Object)((int)(soundLocation.getZ() * 8.0)));
                packet.getFloat().write(0, (Object)Float.valueOf(((Number)this.volume.getSingle(e)).floatValue()));
                packet.getFloat().write(1, (Object)Float.valueOf(((Number)this.pitch.getSingle(e)).floatValue()));
            } else {
                soundLocation = ((Player)this.player.getSingle(e)).getLocation();
                packet.getSoundCategories().write(0, (Object)EnumWrappers.SoundCategory.PLAYERS);
                packet.getSoundEffects().write(0, (Object)Sound.valueOf((String)((String)this.sound.getSingle(e))));
                packet.getIntegers().write(0, (Object)((int)(soundLocation.getX() * 8.0)));
                packet.getIntegers().write(1, (Object)((int)(soundLocation.getY() * 8.0)));
                packet.getIntegers().write(2, (Object)((int)(soundLocation.getZ() * 8.0)));
                packet.getFloat().write(0, (Object)Float.valueOf(((Number)this.volume.getSingle(e)).floatValue()));
                packet.getFloat().write(1, (Object)Float.valueOf(((Number)this.pitch.getSingle(e)).floatValue()));
            }
        }
        try {
            this.protocolManager.sendServerPacket((Player)this.player.getSingle(e), packet);
        }
        catch (InvocationTargetException e1) {
            throw new RuntimeException("[SkMorkaz ERROR] Can not send this packet: " + packet, e1);
        }
    }

    static {
        RegisterManager.registerEffect(EffPlaySoundForPlayer.class, "play [raw] sound %string% at %location% [with] pitch %number% [and] volume %number% (to|for) %player%", "play %string% specifically (to|for) %player% [with] pitch %number% [and] volume %number%");
    }
}

