/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxData;
import org.bukkit.event.Event;

@Name(value="Values of Mox Data")
@Description(value={"Returns all Values of Mox Data object.", "Full tutorial: https://github.com/MorkaZ/MorkazSk/wiki/Mox-Data-tutorial"})
@Examples(value={"set {_values::*} to values of {_mox.data}", "loop {_values::*}:", "\t..."})
@Since(value="1.1-beta2")
@RequiredPlugins(value={"MoxCore"})
public class ExprValuesOfMoxData
extends SimpleExpression<Object> {
    Expression<MoxData> moxDataExpr;

    public boolean isSingle() {
        return false;
    }

    public String toString(Event event, boolean debug) {
        return "values of " + this.moxDataExpr.toString(event, debug);
    }

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.moxDataExpr = expressions[0];
        return true;
    }

    protected Object[] get(Event event) {
        MoxData moxData = (MoxData)this.moxDataExpr.getSingle(event);
        if (moxData != null) {
            return moxData.getChain().getValues().toArray(new Object[moxData.getChain().getValues().size()]);
        }
        return new Object[0];
    }

    static {
        RegisterManager.registerExpression(ExprValuesOfMoxData.class, Object.class, ExpressionType.SIMPLE, "[all] values of %moxdata%");
    }
}

