/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxData;
import com.morkaz.moxlibrary.other.moxdata.MoxPair;
import org.bukkit.event.Event;

@Name(value="Mox Pairs of Mox Data")
@Description(value={"Returns all Mox Pairs of Mox Data object.", "Full tutorial: https://github.com/MorkaZ/MorkazSk/wiki/Mox-Data-tutorial"})
@Examples(value={"set {_mox.pairs::*} to mox pairs of {_mox.data}", "loop {_mox.pairs::*}:", "\tset {_key} to key of loop-value", "\tset {_value} to value of loop-value", "\t..."})
@Since(value="1.1-beta2")
@RequiredPlugins(value={"MoxCore"})
public class ExprPairsOfMoxData
extends SimpleExpression<MoxPair> {
    Expression<MoxData> moxDataExpr;

    public boolean isSingle() {
        return false;
    }

    public String toString(Event event, boolean debug) {
        return "mox pairs of " + this.moxDataExpr.toString(event, debug);
    }

    public Class<? extends MoxPair> getReturnType() {
        return MoxPair.class;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.moxDataExpr = expressions[0];
        return true;
    }

    protected MoxPair[] get(Event event) {
        MoxData moxData = (MoxData)this.moxDataExpr.getSingle(event);
        if (moxData != null) {
            return moxData.getChain().getPairs().toArray(new MoxPair[moxData.getChain().getPairs().size()]);
        }
        return new MoxPair[0];
    }

    static {
        RegisterManager.registerExpression(ExprPairsOfMoxData.class, MoxPair.class, ExpressionType.SIMPLE, "[all] [mox] pairs of %moxdata%");
    }
}

