/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.dedicated;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.events.EvtBlockPistonPull;
import com.morkaz.morkazsk.events.EvtBlockPistonPush;
import com.morkaz.morkazsk.managers.RegisterManager;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

@Name(value="Piston Block")
@Description(value={"Returns piston block in piston events."})
@Examples(value={"on block piston push:", "\tbroadcast \"piston %event-piston-block% at location: %location of event-piston-block% pushed block %event-block% at %event-location%"})
@Since(value="1.1")
public class ExprBlockMovePistonBlock
extends SimpleExpression<Block> {
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        Class[] eventClasses = new Class[]{BlockPistonRetractEvent.class, BlockPistonExtendEvent.class, EvtBlockPistonPush.class, EvtBlockPistonPull.class};
        if (!ScriptLoader.isCurrentEvent((Class[])eventClasses)) {
            Skript.error((String)"[MorkazSk] This expression can be used only in: piston events!");
            return false;
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "event-piston-block";
    }

    @Nullable
    protected Block[] get(Event event) {
        if (event instanceof BlockPistonExtendEvent) {
            return new Block[]{((BlockPistonExtendEvent)event).getBlock()};
        }
        if (event instanceof BlockPistonRetractEvent) {
            return new Block[]{((BlockPistonRetractEvent)event).getBlock()};
        }
        if (event instanceof EvtBlockPistonPush) {
            return new Block[]{((EvtBlockPistonPush)event).getPistonBlock()};
        }
        if (event instanceof EvtBlockPistonPull) {
            return new Block[]{((EvtBlockPistonPull)event).getPistonBlock()};
        }
        return new Block[0];
    }

    static {
        RegisterManager.registerExpression(ExprBlockMovePistonBlock.class, Block.class, ExpressionType.SIMPLE, "event(-| )piston(-| )block");
    }
}

