/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.managers;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.morkaz.morkazsk.MorkazSk;
import com.morkaz.morkazsk.events.listeners.BlockFallListener;
import com.morkaz.morkazsk.events.listeners.BlockPistonMoveListener;
import com.morkaz.morkazsk.events.listeners.PlayerChunkEnterListener;
import com.morkaz.morkazsk.events.listeners.PlayerJumpListener;
import com.morkaz.morkazsk.misc.AnsiColors;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class RegisterManager {
    private static Integer expressionsCount = 0;
    private static Integer effectsCount = 0;
    private static Integer conditionCount = 0;
    private static Integer eventCount = 0;
    private static Integer typesCount = 0;
    private static Integer eventValuesCount = 0;

    public static void loadElementsClasses() {
        MorkazSk plugin = MorkazSk.getInstance();
        try {
            plugin.asSkriptAddon().loadClasses("com.morkaz.morkazsk.expressions", new String[]{"universal", "dedicated"});
            plugin.asSkriptAddon().loadClasses("com.morkaz.morkazsk.events", new String[0]);
            plugin.asSkriptAddon().loadClasses("com.morkaz.morkazsk.conditions", new String[0]);
            plugin.asSkriptAddon().loadClasses("com.morkaz.morkazsk.effects", new String[0]);
            ArrayList<String> optionals = new ArrayList<String>();
            if (Bukkit.getPluginManager().isPluginEnabled("MoxCore")) {
                optionals.add("moxcore");
                Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &5MoxCore &6additional elements scheduled to load!&r"));
            }
            if (Bukkit.getPluginManager().isPluginEnabled("MoxTokensDatabase")) {
                optionals.add("moxtokensdatabase");
                Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &5MoxTokensDatabase &6additional elements scheduled to load!&r"));
            }
            if (Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
                optionals.add("protocollib");
                Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &5ProtocolLib &6additional elements scheduled to load!&r"));
            }
            plugin.asSkriptAddon().loadClasses("com.morkaz.morkazsk.optionals", optionals.toArray(new String[optionals.size()]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <E extends Expression, V> Boolean registerExpression(Class<E> expressionClass, Class<V> returnType, ExpressionType expressionType, String ... patterns) {
        try {
            Skript.registerExpression(expressionClass, returnType, (ExpressionType)expressionType, (String[])patterns);
            Integer n = expressionsCount;
            Integer n2 = expressionsCount = Integer.valueOf(expressionsCount + 1);
            return true;
        }
        catch (Exception e) {
            Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &cException has ben thrown while loading: &f\"" + patterns[0] + "\"&c. Do not worry, it will &aNOT AFFECT OTHER STUFF&c. Details are below. Please, report this here: &1https://github.com/MorkaZ/MorkazSk/issues&r"));
            e.printStackTrace();
            return false;
        }
    }

    public static Boolean registerEffect(Class<? extends Effect> effectClass, String ... patterns) {
        try {
            Skript.registerEffect(effectClass, (String[])patterns);
            Integer n = effectsCount;
            Integer n2 = effectsCount = Integer.valueOf(effectsCount + 1);
        }
        catch (Exception e) {
            Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &cException has ben thrown while loading: &f\"" + patterns[0] + "\"&c. Do not worry, it will &aNOT AFFECT OTHER STUFF&c. Details are below. Please, report this problem here: &1https://github.com/MorkaZ/MorkazSk/issues&r"));
            e.printStackTrace();
        }
        return false;
    }

    public static Boolean registerCondition(Class<? extends Condition> conditionClass, String ... patterns) {
        try {
            Skript.registerCondition(conditionClass, (String[])patterns);
            Integer n = conditionCount;
            Integer n2 = conditionCount = Integer.valueOf(conditionCount + 1);
            return true;
        }
        catch (Exception e) {
            Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &cException has ben thrown while loading: \"&f" + patterns[0] + "\"&c. Do not worry, it will &aNOT AFFECT OTHER STUFF&c. Details are below. Please, report this problem here: &1https://github.com/MorkaZ/MorkazSk/issues&r"));
            e.printStackTrace();
            return false;
        }
    }

    public static <T> Boolean registerType(ClassInfo<T> classInfo) {
        try {
            Classes.registerClass(classInfo);
            Integer n = typesCount;
            Integer n2 = typesCount = Integer.valueOf(typesCount + 1);
            return true;
        }
        catch (Exception e) {
            if (e.getMessage().contains("is already registered")) {
                Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &cType: &d\"" + classInfo.getC().getName() + "\" &cis already registered. Dismissing loading of this type.&r"));
            } else {
                Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &cException has ben thrown while loading type: \"&f" + classInfo.getC().getName() + "\"&c. Do not worry, it will &aNOT AFFECT OTHER STUFF&c. Details are below. Please, report this problem here: &1https://github.com/MorkaZ/MorkazSk/issues&r"));
                e.printStackTrace();
            }
            return false;
        }
    }

    public static SkriptEventInfo registerEvent(String eventName, Class<? extends SkriptEvent> eventType, Class<? extends Event>[] events, String[] patterns, String[] description, String[] examples, String[] requiredPlugins, String since, String documentationID) {
        try {
            SkriptEventInfo eventInfo = Skript.registerEvent((String)eventName, eventType, (Class[])events, (String[])patterns);
            if (description != null) {
                eventInfo.description(description);
            }
            if (examples != null) {
                eventInfo.examples(examples);
            }
            if (since != null) {
                eventInfo.since(since);
            }
            if (documentationID != null) {
                eventInfo.documentationID(documentationID);
            }
            if (requiredPlugins != null) {
                eventInfo.requiredPlugins(requiredPlugins);
            }
            Integer n = eventCount;
            Integer n2 = eventCount = Integer.valueOf(eventCount + 1);
            return eventInfo;
        }
        catch (Exception e) {
            Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &cException has ben thrown while loading: &f" + patterns[0] + "&c. Do not worry, it will &aNOT AFFECT OTHER STUFF&c. Details are below. Please, report this problem here: &1https://github.com/MorkaZ/MorkazSk/issues&r"));
            e.printStackTrace();
            return null;
        }
    }

    public static SkriptEventInfo registerEvent(String eventName, Class<? extends SkriptEvent> eventType, Class<? extends Event>[] events, String ... patterns) {
        return RegisterManager.registerEvent(eventName, eventType, events, patterns, null, null, null, null, null);
    }

    public static <E extends Event, V> Boolean registerEventValue(Class<E> eventClass, Class<V> valueClass, Getter<V, E> getter) {
        try {
            EventValues.registerEventValue(eventClass, valueClass, getter, (int)0);
            Integer n = eventValuesCount;
            Integer n2 = eventValuesCount = Integer.valueOf(eventValuesCount + 1);
            return true;
        }
        catch (Exception e) {
            Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &cException has ben thrown while loading event value: &f\"" + valueClass.getName() + "\"&c of event: &f\"" + eventClass.getName() + "\"&c. Do not worry, it will &aNOT AFFECT OTHER STUFF&c. Details are below. Please, report this problem here: &1https://github.com/MorkaZ/MorkazSk/issues&r"));
            e.printStackTrace();
            return false;
        }
    }

    public static void registerListeners() {
        MorkazSk main = MorkazSk.getInstance();
        if (main == null) {
            return;
        }
        main.getServer().getPluginManager().registerEvents((Listener)new BlockFallListener(), (Plugin)main);
        main.getServer().getPluginManager().registerEvents((Listener)new BlockPistonMoveListener(), (Plugin)main);
        if (main.getConfig().getBoolean("elements.jump-event")) {
            main.getServer().getPluginManager().registerEvents((Listener)new PlayerJumpListener(), (Plugin)main);
        }
        if (main.getConfig().getBoolean("elements.chunk-enter-event")) {
            main.getServer().getPluginManager().registerEvents((Listener)new PlayerChunkEnterListener(), (Plugin)main);
        }
    }

    public static void displayCounts() {
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &f---------------------------------------------------&r"));
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &eAmounts of registered elements:&r"));
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &a" + eventCount + " &eEvents and &a" + eventValuesCount + " &eEvent Values&r"));
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &a" + conditionCount + " &eConditions&r"));
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &a" + effectsCount + " &eEffects&r"));
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &a" + expressionsCount + " &eExpressions&r"));
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &a" + typesCount + " &eTypes&r"));
        Bukkit.getLogger().info(AnsiColors.translate("&", "&9[" + MorkazSk.getInstance().getDescription().getName() + "] &f---------------------------------------------------&r"));
    }
}

