/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.dedicated;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;

@Name(value="Fishing Caught Entity")
@Description(value={"Caught entity (hooked by fishing rod) in fishing event. It may be also fish drop item in specific fishing state."})
@Examples(value={"on fishing:", "\tif fishing state is \"CAUGHT_FISH\":", "\t\tsend \"Wow, you caught %items within caught entity%!\""})
@Since(value="1.0")
public class ExprFishingCaughtEntity
extends SimpleExpression<Entity> {
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        Class<PlayerFishEvent> eventClass = PlayerFishEvent.class;
        if (!ScriptLoader.isCurrentEvent(eventClass)) {
            Skript.error((String)("[MorkazSk] This expression can be used only in: \"" + eventClass.getName() + "\"!"));
            return false;
        }
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "fishing caught entity";
    }

    @Nullable
    protected Entity[] get(Event event) {
        return new Entity[]{((PlayerFishEvent)event).getCaught()};
    }

    static {
        RegisterManager.registerExpression(ExprFishingCaughtEntity.class, Entity.class, ExpressionType.SIMPLE, "[fishing(-| )]caught(-| )entity");
    }
}

