/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.yggdrasil.Fields;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxPair;
import com.morkaz.moxlibrary.other.moxdata.Separator;
import com.morkaz.moxlibrary.other.moxdata.UncorrectStringDataException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import org.bukkit.event.Event;

@Name(value="Mox Pair")
@Description(value={"Returns special Mox Pair of key and value.", "Useable in Mox Data operations."})
@Examples(value={"add value player's health with key \"health\" to {_mox.data} # Adds Mox Pair to Mox Data", "set {_health} to value of \"health\" from {_mox.data}"})
@RequiredPlugins(value={"MoxCore"})
@Since(value="1.1-beta2")
public class ExprMoxPair
extends SimpleExpression<MoxPair> {
    private Expression<String> keyExpr;
    private Expression<?> valueExpr;

    public Class<? extends MoxPair> getReturnType() {
        return MoxPair.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.valueExpr = expressions[0];
        this.keyExpr = expressions[1];
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "mox pair of " + this.keyExpr.toString(event, debug) + " and value " + this.valueExpr.toString(event, debug);
    }

    protected MoxPair[] get(Event e) {
        String key = (String)this.keyExpr.getSingle(e);
        Object value = this.valueExpr.getSingle(e);
        if (key != null && value != null) {
            MoxPair moxPair = new MoxPair(key, value);
            return new MoxPair[]{moxPair};
        }
        return new MoxPair[0];
    }

    static {
        RegisterManager.registerType(new ClassInfo(MoxPair.class, "moxpair").user(new String[]{"moxpair(s)?"}).name("Mox Pair Type").description(new String[]{"Mox Pair type. It holds key and value. Useable in Mox Data operations", "Specially created for databases to not create a lot of columns but can be also used in common scripting."}).usage(new String[]{"set {_mox.pair} to value player keyed \"%player%\""}).examples(new String[]{"set {_mox.pair} to mox pair of value player and key \"%player%\"", "add {_mox.pair} to {_mox.data}", "set {_health} to value of \"health\" from {_mox.data}"}).since("1.1-beta2").defaultExpression((DefaultExpression)new EventValueExpression(MoxPair.class)).parser((Parser)new Parser<MoxPair>(){

            public MoxPair parse(String moxPairString, ParseContext context) {
                try {
                    if (moxPairString.contains(Separator.PAIR.toString())) {
                        return new MoxPair(moxPairString);
                    }
                }
                catch (UncorrectStringDataException e) {
                    e.printStackTrace();
                    Skript.error((String)("[MorkazSk] Problem accoured while trying to create MoxPair from text (probably there was no key or value in your string). String that generated this problem: " + moxPairString));
                }
                return null;
            }

            public boolean canParse(ParseContext context) {
                return true;
            }

            public String toString(MoxPair moxPair, int flags) {
                return moxPair.toString();
            }

            public String getDebugMessage(MoxPair moxPair) {
                return moxPair.toString();
            }

            public String toVariableNameString(MoxPair moxPair) {
                return moxPair.toString();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer((Serializer)new Serializer<MoxPair>(){

            public Fields serialize(MoxPair moxPair) throws NotSerializableException {
                Fields fields = new Fields();
                fields.putObject("content", (Object)moxPair.toString());
                return fields;
            }

            public void deserialize(MoxPair o, Fields f) throws StreamCorruptedException {
            }

            public MoxPair deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                try {
                    return new MoxPair(fields.getObject("content").toString());
                }
                catch (UncorrectStringDataException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public boolean canBeInstantiated() {
                return false;
            }

            public boolean mustSyncDeserialization() {
                return false;
            }
        }));
        RegisterManager.registerExpression(ExprMoxPair.class, MoxPair.class, ExpressionType.SIMPLE, "[mox pair [of]] value %object% ((with|and) key|key[ed [by]]) %string%");
    }
}

