/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.yggdrasil.Fields;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxChain;
import com.morkaz.moxlibrary.other.moxdata.MoxData;
import com.morkaz.moxlibrary.other.moxdata.MoxPair;
import com.morkaz.moxlibrary.other.moxdata.Separator;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import org.bukkit.event.Event;

@Name(value="Mox Data")
@Description(value={"Creates new instance of Mox Data.", "You can create it empty or from text object."})
@Examples(value={"set {_mox.data} to new mox data with main key \"%player%\"", "add value player's health with key \"health\" to {_mox.data}", "set {_health} to value of \"health\" from {_mox.data}", "#IMPORTANT - After server restart, values of MoxData saved in variables will be texts.", "#You will have to parse them like it is done in example below:", " ", "on script load:", "\tloop pairs of {mox.data.items}: #Example with mox data that holds item types", "\t\tset {_key} to key of pair loop-value", "\t\tset {_value} to \"%value of pair loop-value%\" parsed as item #Parsing text to type", "\t\tadd pair value {_value} keyed {_key} to {mox.data.items} #It will replace old pair with new one"})
@RequiredPlugins(value={"MoxCore"})
@Since(value="1.1-beta2")
public class ExprMoxData
extends SimpleExpression<MoxData> {
    private Expression<String> stringExpr;
    private Expression<String> mainKeyExpr;
    private int pattern = 0;

    public Class<? extends MoxData> getReturnType() {
        return MoxData.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = pattern;
        if (pattern == 1) {
            this.mainKeyExpr = expressions[0];
        } else if (pattern == 2) {
            this.stringExpr = expressions[0];
        } else if (pattern == 3) {
            this.stringExpr = expressions[0];
            this.mainKeyExpr = expressions[1];
        }
        return true;
    }

    public String toString(Event event, boolean debug) {
        if (this.pattern == 0) {
            return "empty mox data";
        }
        if (this.pattern == 1) {
            return "empty mox data with main key " + this.mainKeyExpr.toString(event, debug);
        }
        if (this.pattern == 2) {
            return "mox data of " + this.stringExpr.toString(event, debug);
        }
        return "mox data of " + this.stringExpr.toString(event, debug) + " with main key " + this.mainKeyExpr.toString(event, debug);
    }

    protected MoxData[] get(Event e) {
        if (this.pattern == 0) {
            MoxData moxData = new MoxData(new MoxChain(new MoxPair[0]));
            return new MoxData[]{moxData};
        }
        if (this.pattern == 1) {
            String mainKey = (String)this.mainKeyExpr.getSingle(e);
            if (mainKey != null) {
                MoxData moxData = new MoxData(mainKey, new MoxChain(new MoxPair[0]));
                return new MoxData[]{moxData};
            }
        } else if (this.pattern == 2) {
            String moxDataString = (String)this.stringExpr.getSingle(e);
            if (moxDataString != null) {
                MoxData moxData = new MoxData(moxDataString);
                return new MoxData[]{moxData};
            }
        } else if (this.pattern == 3) {
            String moxDataString = (String)this.stringExpr.getSingle(e);
            String mainKey = (String)this.mainKeyExpr.getSingle(e);
            if (moxDataString != null && mainKey != null) {
                MoxData moxData = new MoxData(moxDataString);
                moxData.setMainKey(mainKey);
                return new MoxData[]{moxData};
            }
        }
        return new MoxData[0];
    }

    static {
        RegisterManager.registerType(new ClassInfo(MoxData.class, "moxdata").user(new String[]{"moxdata(s)?"}).name("Mox Data Type").description(new String[]{"Mox Data type. It can hold multiple values indexed by keys in one field called Mox Chain.", "Specially created for databases to not create a lot of columns but it can be also used in normal skript features - for example in NBT Tags."}).usage(new String[]{"new mox data [from %string] [with main key %string%]"}).examples(new String[]{"set {_mox.data} to new mox data with main key \"%player%\"", "add value player's health with key \"health\" to {_mox.data}", "set {_health} to value of \"health\" from {_mox.data}", "set {_mox.data.text} to \"%{_mox.data}%\"", "set {_mox.data.from.text} to {_mox.data.text} parsed as mox data", "#Values after this transformation will be saved as string type. You will have to parse/initialize values from strings by yourself. It is good to use mox data for texts and numbers instead of complicated object instances."}).since("1.1-beta2").defaultExpression((DefaultExpression)new EventValueExpression(MoxData.class)).parser((Parser)new Parser<MoxData>(){

            public MoxData parse(String moxDataString, ParseContext context) {
                if (moxDataString.contains(Separator.PAIR.toString()) || moxDataString.contains(Separator.MAIN_KEY.toString())) {
                    return new MoxData(moxDataString);
                }
                return null;
            }

            public boolean canParse(ParseContext context) {
                return true;
            }

            public String toString(MoxData moxData, int flags) {
                return moxData.toString();
            }

            public String getDebugMessage(MoxData moxData) {
                return "mox data with main key " + moxData.getMainKey();
            }

            public String toVariableNameString(MoxData moxData) {
                return moxData.toString();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer((Serializer)new Serializer<MoxData>(){

            public Fields serialize(MoxData moxData) throws NotSerializableException {
                Fields fields = new Fields();
                fields.putObject("content", (Object)moxData.toString());
                return fields;
            }

            public void deserialize(MoxData o, Fields f) throws StreamCorruptedException {
            }

            public MoxData deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                return new MoxData(fields.getObject("content").toString());
            }

            public boolean canBeInstantiated() {
                return false;
            }

            public boolean mustSyncDeserialization() {
                return false;
            }
        }));
        RegisterManager.registerExpression(ExprMoxData.class, MoxData.class, ExpressionType.SIMPLE, "(new|empty) mox data", "(new|empty) mox data with main key %string%", "[new] mox data (of|from) %string%", "[new] mox data (of|from) %string% with main key %string%");
    }
}

