/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxPair;
import org.bukkit.event.Event;

@Name(value="Key Name of Mox Pair")
@Description(value={"Returns Key Name of Mox Pair."})
@Examples(value={"set {_mox.pair} to mox pair of key \"MySuperKey\" with value \"My Super Value\"", "set {_key.name} to key of pair {_mox.pair}"})
@Since(value="1.1-beta2")
@RequiredPlugins(value={"MoxCore"})
public class ExprKeyOfPair
extends SimpleExpression<String> {
    Expression<MoxPair> moxPairExpr;

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "key of " + this.moxPairExpr.toString(event, debug);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.moxPairExpr = expressions[0];
        return true;
    }

    protected String[] get(Event event) {
        MoxPair moxPair = (MoxPair)this.moxPairExpr.getSingle(event);
        if (moxPair != null) {
            return new String[]{moxPair.getKey()};
        }
        return new String[0];
    }

    static {
        RegisterManager.registerExpression(ExprKeyOfPair.class, String.class, ExpressionType.SIMPLE, "key of [pair] %moxpair%");
    }
}

