/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.universal;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@Name(value="Tier/Level of Potion Effect of Entity")
@Description(value={"Returns tier level of given potion effect type applied to entity."})
@Examples(value={"set {_tier} to tier of potion effect slow of victim"})
@Since(value="1.0")
public class ExprTierOfPotionOnEntity
extends SimpleExpression<Number> {
    private Expression<PotionEffectType> potionExpr;
    private Expression<LivingEntity> entityExpr;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.potionExpr = expressions[0];
        this.entityExpr = expressions[1];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "tier of potion effect type " + this.potionExpr.toString(event, debug) + " of " + this.entityExpr.toString(event, debug);
    }

    protected Number[] get(Event e) {
        PotionEffectType[] effects = (PotionEffectType[])this.potionExpr.getArray(e);
        LivingEntity entity = (LivingEntity)this.entityExpr.getSingle(e);
        if (effects != null && entity != null) {
            if (effects.length == 0) {
                return null;
            }
            Collection activePotionEffects = ((LivingEntity)this.entityExpr.getSingle(e)).getActivePotionEffects();
            Number[] tiers = new Integer[activePotionEffects.size()];
            int counter = 0;
            block0: for (PotionEffect activePotionEffect : activePotionEffects) {
                for (PotionEffectType effectType : effects) {
                    if (!activePotionEffect.getType().equals((Object)effectType)) continue;
                    tiers[counter] = activePotionEffect.getAmplifier() + 1;
                    ++counter;
                    continue block0;
                }
            }
            return tiers;
        }
        return null;
    }

    static {
        RegisterManager.registerExpression(ExprTierOfPotionOnEntity.class, Number.class, ExpressionType.SIMPLE, "tier[s] of [potion [effect [type]]] %potioneffecttypes% of %livingentity%");
    }
}

