/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.effects;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Push Player or Entity from Location")
@Description(value={"It will push living entity from location direction with specific force (if definded)."})
@Examples(value={"#Force above 2 is very strong", "push player from location 1 meter behind and 1 meter below player with force 1.5", "push victim from attacker", "#Superman example", "on leftclick:", "\tpush player from location 1.5 meter behind player with force 2"})
@Since(value="1.0")
public class EffPushEntityFromLocation
extends Effect {
    private Expression<LivingEntity> entityExpr;
    private Expression<Location> locationExpr;
    private Expression<Number> forceExpr;
    private int pattern = 0;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = pattern;
        this.entityExpr = expressions[0];
        this.locationExpr = expressions[1];
        if (pattern == 1) {
            this.forceExpr = expressions[2];
        }
        return true;
    }

    public String toString(Event event, boolean debug) {
        if (this.pattern == 0) {
            return "push " + this.entityExpr.toString(event, debug) + " from " + this.locationExpr.toString(event, debug);
        }
        return "push " + this.entityExpr.toString(event, debug) + " from " + this.locationExpr.toString(event, debug) + " with force " + this.forceExpr.toString(event, debug);
    }

    protected void execute(Event event) {
        LivingEntity entity = (LivingEntity)this.entityExpr.getSingle(event);
        Location location = (Location)this.locationExpr.getSingle(event);
        Number force = 1.0;
        if (entity == null || location == null) {
            return;
        }
        if (this.forceExpr != null && (force = (Number)this.forceExpr.getSingle(event)) == null) {
            force = 1.0;
        }
        Vector direction = entity.getLocation().toVector().subtract(location.toVector()).multiply(force.doubleValue());
        entity.setVelocity(direction);
    }

    static {
        RegisterManager.registerEffect(EffPushEntityFromLocation.class, "push [the] %livingentity% from %location%", "push [the] %livingentity% from %location% with force %number%");
    }
}

