/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;

@Name(value="Entity Having Potion Effect")
@Description(value={"Checks if living entity has applied given potion effect(s). ", "If one of this effects will exist on entity, return will be \"true\"."})
@Examples(value={"on damage:", "\tif attacker has potion effect slow:", "\t\tadd 1 to damage"})
@Since(value="1.0")
public class CondIsEntityHavingPotionEffect
extends Condition {
    private Expression<PotionEffectType> potionEffectTypeExpr;
    private Expression<LivingEntity> entityExpr;
    int pattern = 0;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = pattern;
        this.entityExpr = expressions[0];
        this.potionEffectTypeExpr = expressions[1];
        this.setNegated(pattern == 1);
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return this.entityExpr.toString(event, debug) + " has potion effect " + this.potionEffectTypeExpr.toString(event, debug);
        }
        return this.entityExpr.toString(event, debug) + " has not potion effect " + this.potionEffectTypeExpr.toString(event, debug);
    }

    public boolean check(Event event) {
        LivingEntity[] entities = (LivingEntity[])this.entityExpr.getArray(event);
        PotionEffectType potionEffectType = (PotionEffectType)this.potionEffectTypeExpr.getSingle(event);
        if (entities != null && potionEffectType != null) {
            for (LivingEntity entity : entities) {
                Collection potionEffects = entity.getActivePotionEffects();
                if (!potionEffects.contains(potionEffectType)) continue;
                return !this.isNegated();
            }
            return this.isNegated();
        }
        return this.isNegated();
    }

    static {
        RegisterManager.registerCondition(CondIsEntityHavingPotionEffect.class, "[morkazsk] [the] %livingentity% (has|is having) potion effect %potioneffecttypes%", "[morkazsk] [the] %livingentity% (hasn(t|'t)|is((nt|n't)| not) having) potion effect %potioneffecttypes%");
    }
}

