/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxData;
import org.bukkit.event.Event;

@Name(value="Keys of Mox Data")
@Description(value={"Returns all Keys of Mox Data object."})
@Examples(value={"set {_keys::*} to keys of {_mox.data}", "loop {_keys::*}:", "\t..."})
@Since(value="1.1-beta2")
public class ExprKeysOfMoxData
extends SimpleExpression<String> {
    Expression<MoxData> moxDataExpr;

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "keys of " + this.moxDataExpr.toString(event, debug);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.moxDataExpr = expressions[0];
        return true;
    }

    protected String[] get(Event event) {
        MoxData moxData = (MoxData)this.moxDataExpr.getSingle(event);
        if (moxData != null) {
            return moxData.getChain().getKeys().toArray(new String[moxData.getChain().getKeys().size()]);
        }
        return new String[0];
    }

    static {
        RegisterManager.registerExpression(ExprKeysOfMoxData.class, String.class, ExpressionType.SIMPLE, "[all] keys of %moxdata%");
    }
}

