/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxData;
import com.morkaz.moxlibrary.other.moxdata.MoxPair;
import org.bukkit.event.Event;

@Name(value="Add Mox Pair to Mox Data")
@Description(value={"This effect will add mox pair to chain of mox data."})
@Examples(value={"add pair of value \"text value\" with key \"key\" to {_mox.data}"})
@Since(value="1.1-beta2")
public class EffAddPairToData
extends Effect {
    private Expression<MoxData> moxDataExpr;
    private Expression<MoxPair> moxPairExpr;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.moxPairExpr = expressions[0];
        this.moxDataExpr = expressions[1];
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "add " + this.moxPairExpr.toString(event, debug) + " to " + this.moxDataExpr.toString(event, debug);
    }

    protected void execute(Event e) {
        MoxData moxData = (MoxData)this.moxDataExpr.getSingle(e);
        MoxPair[] moxPairs = (MoxPair[])this.moxPairExpr.getArray(e);
        if (moxData != null && moxPairs != null) {
            for (MoxPair moxPair : moxPairs) {
                moxData.addPair(moxPair);
            }
        }
    }

    static {
        RegisterManager.registerEffect(EffAddPairToData.class, "add [mox] pair [of] %moxpairs% to %moxdata%");
    }
}

