/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.moxcore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.moxlibrary.other.moxdata.MoxData;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Mox Data contains Mox Key")
@Description(value={"Checks if Mox Data contains Mox Pair with given key."})
@Examples(value={"if {_mox.data} doesn't contain pair with key \"my-key\":", "\tsend \"This mox data does not contain this key!\""})
@Since(value="1.1-beta2")
public class CondIsPairInMoxData
extends Condition {
    private Expression<MoxData> moxDataExpr;
    private Expression<String> keyExpr;
    int pattern = 0;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = pattern;
        this.moxDataExpr = expressions[0];
        this.keyExpr = expressions[1];
        this.setNegated(pattern == 1);
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return this.moxDataExpr.toString(event, debug) + " contains pair with key " + this.keyExpr.toString(event, debug);
        }
        return this.moxDataExpr.toString(event, debug) + " does not contain pair with key " + this.keyExpr.toString(event, debug);
    }

    public boolean check(Event event) {
        String[] keys = (String[])this.keyExpr.getArray(event);
        MoxData moxData = (MoxData)this.moxDataExpr.getSingle(event);
        if (keys != null && moxData != null) {
            for (String key : keys) {
                if (!moxData.getKeys().contains(key)) continue;
                return !this.isNegated();
            }
        }
        return this.isNegated();
    }

    static {
        RegisterManager.registerCondition(CondIsPairInMoxData.class, "%moxdata% contain[s] [mox] pair with key[s] %strings%", "%moxdata% do(esn't|es not| not) contain[s] [mox] pair with key[s] %strings%");
    }
}

