/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.dedicated;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.events.EvtChunkEnter;
import com.morkaz.morkazsk.managers.RegisterManager;
import javax.annotation.Nullable;
import org.bukkit.Chunk;
import org.bukkit.event.Event;

@Name(value="Actual Chunk of Chunk Enter Event")
@Description(value={"Returns actual chunk of player's location in event \"on chunk enter\"."})
@Examples(value={"on chunk enter:", "\tsend \"Your actual chunk is: %event-actual-chunk%\" to player"})
@Since(value="1.1")
public class ExprChunkEnterNewChunk
extends SimpleExpression<Chunk> {
    public Class<? extends Chunk> getReturnType() {
        return Chunk.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        Class<EvtChunkEnter> eventClass = EvtChunkEnter.class;
        if (!ScriptLoader.isCurrentEvent(eventClass)) {
            Skript.error((String)("[MorkazSk] This expression can be used only in: \"" + eventClass.getName() + "\"!"));
            return false;
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "event-actual-chunk";
    }

    @Nullable
    protected Chunk[] get(Event event) {
        return new Chunk[]{((EvtChunkEnter)event).getNewChunk()};
    }

    static {
        RegisterManager.registerExpression(ExprChunkEnterNewChunk.class, Chunk.class, ExpressionType.SIMPLE, "[morkazsk] event(-| )(new|actual)(-| )chunk");
    }
}

