/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.morkazsk.misc.ToolBox;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.event.Event;

@Name(value="Play Sound at Location")
@Description(value={"It will play sound at specific location with given pitch and volume for everyone.", "Use bukkit \"Sound\" enum names as sound name.", "List of names is here: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Sound.html", "Bukkit names may be in any case heigh and may be separated with \".\" instead of \"_\"."})
@Examples(value={"on rightclick:", "\tmorkazsk play sound \"entity_bat_death\" at player with pitch 2.0 and volume 2.0 #Make sure to prefix effects that may be identical as other addons syntaxes"})
@Since(value="1.0")
public class EffPlaySound
extends Effect {
    private Expression<String> soundExpr;
    private Expression<Number> pitchExpr;
    private Expression<Number> volumeExpr;
    private Expression<Location> locationExpr;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.soundExpr = expressions[0];
        this.locationExpr = expressions[1];
        this.pitchExpr = expressions[2];
        this.volumeExpr = expressions[3];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "play sound " + this.soundExpr.toString(event, debug) + " at " + this.locationExpr.toString(event, debug) + " with pitch " + this.pitchExpr.toString(event, debug) + " and volume " + this.volumeExpr.toString(event, debug);
    }

    protected void execute(Event event) {
        String sound = (String)this.soundExpr.getSingle(event);
        Location location = (Location)this.locationExpr.getSingle(event);
        if (sound == null || location == null) {
            return;
        }
        if (!ToolBox.enumContains(Sound.class, sound = sound.toUpperCase().replace(".", "_")).booleanValue()) {
            Skript.error((String)("[MorkazSk] Sound: \t" + sound + "\t does not exist in bukkit enums."));
            return;
        }
        Float pitch = this.pitchExpr.getSingle(event) == null ? (Number)Float.valueOf(1.0f) : (Number)((Number)this.pitchExpr.getSingle(event));
        Float volume = this.volumeExpr.getSingle(event) == null ? (Number)Float.valueOf(1.0f) : (Number)((Number)this.volumeExpr.getSingle(event));
        location.getWorld().playSound(location, Sound.valueOf((String)sound), ((Number)volume).floatValue(), ((Number)pitch).floatValue());
    }

    static {
        RegisterManager.registerEffect(EffPlaySound.class, "[morkazsk] play [raw] sound %string% at %location% [with] pitch %number% [and] volume %number%");
    }
}

