/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.effects;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Naturally Break Block")
@Description(value={"This effect will naturally break given block.", "It is possible to define specific tool which block will be broken (in this situation drop can be modified by this tool)."})
@Examples(value={"command break:", "\ttrigger:", "\t\tbreak target-block with player's tool"})
@Since(value="1.0")
public class EffBreakBlock
extends Effect {
    private Expression<Block> blockExpr;
    private Expression<ItemStack> itemExpr;

    public boolean init(Expression<?>[] e, int pattern, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.blockExpr = e[0];
        if (pattern == 1) {
            this.itemExpr = e[1];
        }
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return null;
    }

    protected void execute(Event e) {
        Block block = (Block)this.blockExpr.getSingle(e);
        if (block != null) {
            if (this.itemExpr != null) {
                ItemStack item = (ItemStack)this.itemExpr.getSingle(e);
                if (item != null) {
                    block.breakNaturally(item);
                }
            } else {
                block.breakNaturally();
            }
        }
    }

    static {
        RegisterManager.registerEffect(EffBreakBlock.class, "[morkazsk] [naturally] break %block%", "[morkazsk] [naturally] break %block% [(using|with) %itemstack%]");
    }
}

