/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.universal;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import com.google.common.collect.Lists;
import com.morkaz.morkazsk.managers.RegisterManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.bukkit.event.Event;

@Name(value="Sorted List By Values With Custom Format")
@Description(value={"Returns sorted list with custom format of values.", "Use @value and @index to manipulate content of variable list."})
@Examples(value={"set {_top::*} to sorted {levels::players::*} from highest to lowest with format \"@index: @value LVL\"", "loop {_top::*}:", "\tsend \"%loop-value%\" to player"})
@Since(value="1.0")
public class ExprSortWithCustomOutput
extends SimpleExpression<String> {
    private Variable<Number> variableList;
    private Expression<String> format;
    private int pattern;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int pattern, Kleenean kl, SkriptParser.ParseResult pr) {
        try {
            this.variableList = (Variable)expr[0];
        }
        catch (ClassCastException e) {
            Skript.error((String)"You must put values into variable list that you want to sort because this expression reads index and value from variable.");
            return false;
        }
        this.format = expr[1];
        this.pattern = pattern;
        return true;
    }

    public String toString(Event event, boolean debug) {
        if (this.pattern == 0) {
            return "soreted " + this.variableList.toString(event, debug) + "from highest to lowest with format " + this.format.toString(event, debug);
        }
        return "soreted " + this.variableList.toString(event, debug) + "from lowest to highest with format " + this.format.toString(event, debug);
    }

    protected String[] get(Event e) {
        String customFormat = (String)this.format.getSingle(e);
        if (this.variableList == null || customFormat == null) {
            return null;
        }
        Iterator iterator = this.variableList.variablesIterator(e);
        ArrayList<Pair> pairList = new ArrayList<Pair>();
        while (iterator.hasNext()) {
            pairList.add((Pair)iterator.next());
        }
        pairList.sort(Comparator.comparing(p -> Double.valueOf(p.getValue().toString())));
        ArrayList<String> customOutputList = new ArrayList<String>();
        for (Pair variableContent : pairList) {
            customOutputList.add(customFormat.replace("@value", variableContent.getValue() + "").replace("@index", (CharSequence)variableContent.getKey()));
        }
        if (this.pattern == 0) {
            return Lists.reverse(customOutputList).toArray(new String[customOutputList.size()]);
        }
        if (this.pattern == 1) {
            return customOutputList.toArray(new String[customOutputList.size()]);
        }
        return null;
    }

    static {
        RegisterManager.registerExpression(ExprSortWithCustomOutput.class, String.class, ExpressionType.SIMPLE, "sorted %numbers% from highest to lowest with (output|format) %string%", "sorted %numbers% from lowest to highest with (output|format) %string%");
    }
}

