/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.protocollib;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.morkazsk.misc.ToolBox;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Spawn Particle for Player")
@Description(value={"Spawn particle for single player at location."})
@Examples(value={"spawn 20 of particle \"FLAME\" for player at player offset by 0.2, 0.2, 0.2 with speed 0.05"})
@RequiredPlugins(value={"ProtocolLib"})
@Since(value="1.0")
public class EffShowParticleToPlayer
extends Effect {
    private Expression<String> particle;
    private Expression<Player> player;
    private Expression<Location> location;
    private Expression<Number> offsetX;
    private Expression<Number> offsetY;
    private Expression<Number> offsetZ;
    private Expression<Number> speed;
    private Expression<Number> amount;
    private ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.amount = expressions[0];
        this.particle = expressions[1];
        this.player = expressions[2];
        this.location = expressions[3];
        this.offsetX = expressions[4];
        this.offsetY = expressions[5];
        this.offsetZ = expressions[6];
        this.speed = expressions[7];
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "spawn " + this.amount.toString(event, debug) + " of particles " + this.particle.toString(event, debug) + " for " + this.player.toString(event, debug) + " at " + this.location.toString(event, debug) + " offset by " + this.offsetX.toString(event, debug) + ", " + this.offsetY.toString(event, debug) + ", " + this.offsetZ.toString(event, debug) + " with speed " + this.speed.toString(event, debug);
    }

    protected void execute(Event e) {
        if (this.particle.getSingle(e) != null && this.player.getSingle(e) != null && this.location.getSingle(e) != null && this.offsetX.getSingle(e) != null && this.offsetY.getSingle(e) != null && this.offsetZ.getSingle(e) != null) {
            if (!ToolBox.enumContains(EnumWrappers.Particle.class, (String)this.particle.getSingle(e)).booleanValue()) {
                Skript.warning((String)("[MorkazSk] Given particle name: \"" + (String)this.particle.getSingle(e) + "\" does not exist in ProtocolLib particle names list!"));
                return;
            }
            PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.WORLD_PARTICLES);
            packet.getFloat().write(0, (Object)Float.valueOf((float)((Location)this.location.getSingle(e)).getX())).write(1, (Object)Float.valueOf((float)((Location)this.location.getSingle(e)).getY())).write(2, (Object)Float.valueOf((float)((Location)this.location.getSingle(e)).getZ())).write(3, (Object)Float.valueOf(((Number)this.offsetX.getSingle(e)).floatValue())).write(4, (Object)Float.valueOf(((Number)this.offsetY.getSingle(e)).floatValue())).write(5, (Object)Float.valueOf(((Number)this.offsetZ.getSingle(e)).floatValue())).write(6, (Object)Float.valueOf(((Number)this.speed.getSingle(e)).floatValue()));
            packet.getIntegers().write(0, (Object)((Number)this.amount.getSingle(e)).intValue());
            packet.getParticles().write(0, (Object)EnumWrappers.Particle.getByName((String)((String)this.particle.getSingle(e))));
            try {
                this.protocolManager.sendServerPacket((Player)this.player.getSingle(e), packet);
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException("[MorkazSk] ERROR EffShowParticleToPlayer - Unnable to send this packet: " + packet, e1);
            }
        }
    }

    static {
        RegisterManager.registerEffect(EffShowParticleToPlayer.class, "([morkazsk ]|[mor.])(spawn|show) %number%[ of] particle[s] %string% (to|for) %player% at %location% offset[ by] %number%(, | and )%number%(, | and )%number% with speed %number%");
    }
}

