/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.optionals.protocollib;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.morkaz.morkazsk.managers.RegisterManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Show Block Break Stage to Player")
@Description(value={"This effect will show block break stage of block in given location."})
@Examples(value={"on rightclick:", "\tset {_block} to event-block", "\tloop 6 times:", "\t\tshow block break stage loop-number at {_block} to all players", "\t\twait 2 tick", "\tbreak {_block}"})
@Since(value="1.0")
public class EffShowBlockBreakStage
extends Effect {
    private Expression<Number> stageExpr;
    private Expression<Location> locationExpr;
    private Expression<Player> playerExpr;
    private ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.stageExpr = expressions[0];
        this.locationExpr = expressions[1];
        this.playerExpr = expressions[2];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "show block break stage " + this.stageExpr.toString(event, debug) + " at " + this.locationExpr.toString(event, debug) + " to " + this.playerExpr.toString(event, debug);
    }

    protected void execute(Event event) {
        Location location = (Location)this.locationExpr.getSingle(event);
        Number stage = (Number)this.stageExpr.getSingle(event);
        Player[] players = (Player[])this.playerExpr.getArray(event);
        if (location != null && stage != null && players != null) {
            PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.BLOCK_BREAK_ANIMATION);
            packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
            packet.getIntegers().write(0, (Object)new Random().nextInt(2000));
            packet.getIntegers().write(1, (Object)stage.intValue());
            try {
                for (Player player : players) {
                    this.protocolManager.sendServerPacket(player, packet);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        RegisterManager.registerEffect(EffShowBlockBreakStage.class, "([morkazsk ]|[mor.])show block (damage|break) stage %number% at %location% (for|to) %players%");
    }
}

