/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.universal;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@Name(value="Duration of Potion Effect")
@Description(value={"Returns duration of applied potion effect of entity."})
@Examples(value={"set {_duration} to duration of potion effect slow of player", "\tif {_duration} < 10 seconds:", "\t\tsend \"Slow will disappear in %{_duration}%!\""})
@Since(value="1.0")
public class ExprDurationOfPotionOnEntity
extends SimpleExpression<Timespan> {
    private Expression<PotionEffectType> potionExpr;
    private Expression<LivingEntity> entityExpr;

    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.potionExpr = expressions[0];
        this.entityExpr = expressions[1];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "duration of potion effect type " + this.potionExpr.toString(event, debug) + " of " + this.entityExpr.toString(event, debug);
    }

    protected Timespan[] get(Event e) {
        PotionEffectType[] effects = (PotionEffectType[])this.potionExpr.getArray(e);
        LivingEntity entity = (LivingEntity)this.entityExpr.getSingle(e);
        if (effects != null && entity != null) {
            if (effects.length == 0) {
                return null;
            }
            Collection activePotionEffects = ((LivingEntity)this.entityExpr.getSingle(e)).getActivePotionEffects();
            Timespan[] times = new Timespan[activePotionEffects.size()];
            int counter = 0;
            block0: for (PotionEffect p : activePotionEffects) {
                for (PotionEffectType effectType : effects) {
                    if (!p.getType().equals((Object)effectType)) continue;
                    times[counter] = Timespan.fromTicks_i((long)p.getDuration());
                    ++counter;
                    continue block0;
                }
            }
            return times;
        }
        return null;
    }

    static {
        RegisterManager.registerExpression(ExprDurationOfPotionOnEntity.class, Timespan.class, ExpressionType.SIMPLE, "([morkazsk ]|[mor.])duration[s] of [potion [effect [type]]] %potioneffecttypes% of %livingentity%");
    }
}

