/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.expressions.universal;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Drops Of Block")
@Description(value={"Returns generated drop list of block. You can specify tool using second syntax."})
@Examples(value={"set {_drops::*} to drops of block", "set {_with.tool.drops::*} to drops of block with player's tool"})
@Since(value="1.0")
public class ExprDropOfBlock
extends SimpleExpression<ItemStack> {
    Expression<Block> blockExpr;
    Expression<ItemStack> itemExpr;
    int pattern = 0;

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean debug) {
        if (this.pattern == 0) {
            return "drops of " + this.blockExpr.toString(event, debug);
        }
        return "drops of " + this.blockExpr.toString(event, debug) + " with " + this.itemExpr.toString(event, debug);
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.blockExpr = expressions[0];
        this.pattern = pattern;
        if (pattern == 1) {
            this.itemExpr = expressions[1];
        }
        return true;
    }

    protected ItemStack[] get(Event event) {
        Block block = (Block)this.blockExpr.getSingle(event);
        if (block != null) {
            if (this.itemExpr == null) {
                return block.getDrops().toArray(new ItemStack[block.getDrops().size()]);
            }
            ItemStack item = (ItemStack)this.itemExpr.getSingle(event);
            if (item != null) {
                return block.getDrops(item).toArray(new ItemStack[block.getDrops().size()]);
            }
            return block.getDrops().toArray(new ItemStack[block.getDrops().size()]);
        }
        return new ItemStack[0];
    }

    static {
        RegisterManager.registerExpression(ExprDropOfBlock.class, ItemStack.class, ExpressionType.SIMPLE, "([morkazsk ]|[mor.])drops of %block%", "([morkazsk ]|[mor.])drops of %block% (with|using) [tool] %itemstack%");
    }
}

