/*
 * Decompiled with CFR 0.152.
 */
package com.morkaz.morkazsk.effects;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.morkaz.morkazsk.managers.RegisterManager;
import com.morkaz.morkazsk.misc.ToolBox;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.event.Event;

@Name(value="Spawn Particle at Location")
@Description(value={"This effect will spawn specified particle with given options. It will be spawned for everyone", "If chunk will be not loaded, it will not spawn particle, so it is safe and it will not affect your TPS that much like normal spawning may do.", "Use bukkit \"Particle\" enum names as particle name. You can use dots and name do not have to be upper cased.", "List of names is here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Particle.html"})
@Examples(value={"#0.01 value is speed in this case.", "spawn 20 of \"flame\":0.01 offset by 0.2, 0.2, 0.2 at location 2 meter above player", "spawn 20 of \"flame\" offset by 0.2, 0.2, 0.2 with extra 0.01 at location 2 meter above player"})
@Since(value="1.0")
public class EffSpawnParticle
extends Effect {
    private Expression<String> particleExpr;
    private Expression<Location> locationExpr;
    private Expression<Number> offsetXExpr;
    private Expression<Number> offsetYExpr;
    private Expression<Number> offsetZExpr;
    private Expression<Number> amountExpr;
    private Expression<Number> extraExpr;
    private int pattern = 0;

    public boolean init(Expression<?>[] e, int pattern, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.pattern = pattern;
        if (pattern == 0) {
            this.amountExpr = e[0];
            this.particleExpr = e[1];
            this.extraExpr = e[2];
            this.offsetXExpr = e[3];
            this.offsetYExpr = e[4];
            this.offsetZExpr = e[5];
            this.locationExpr = e[6];
        } else if (pattern == 1) {
            this.amountExpr = e[0];
            this.particleExpr = e[1];
            this.offsetXExpr = e[2];
            this.offsetYExpr = e[3];
            this.offsetZExpr = e[4];
            this.extraExpr = e[5];
            this.locationExpr = e[6];
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return "spawn " + this.amountExpr.toString(event, debug) + " of " + this.particleExpr.toString(event, debug) + ":" + this.extraExpr.toString(event, debug) + " offset by " + this.offsetXExpr.toString(event, debug) + ", " + this.offsetYExpr.toString(event, debug) + ", " + this.offsetZExpr.toString(event, debug) + " at location " + this.locationExpr.toString(event, debug);
        }
        return "spawn " + this.amountExpr.toString(event, debug) + " of " + this.particleExpr.toString(event, debug) + " offset by " + this.offsetXExpr.toString(event, debug) + ", " + this.offsetYExpr.toString(event, debug) + ", " + this.offsetZExpr.toString(event, debug) + " with extra " + this.extraExpr.toString(event, debug) + " at location " + this.locationExpr.toString(event, debug);
    }

    protected void execute(Event e) {
        Number amount = (Number)this.amountExpr.getSingle(e);
        String particleName = (String)this.particleExpr.getSingle(e);
        Number extra = (Number)this.extraExpr.getSingle(e);
        Number offsetX = (Number)this.offsetXExpr.getSingle(e);
        Number offsetY = (Number)this.offsetYExpr.getSingle(e);
        Number offsetZ = (Number)this.offsetZExpr.getSingle(e);
        Location location = (Location)this.locationExpr.getSingle(e);
        if (amount != null && particleName != null && extra != null && offsetX != null && offsetY != null && offsetZ != null && location != null) {
            if (!ToolBox.enumContains(Particle.class, particleName = particleName.toUpperCase().replace(".", "_")).booleanValue()) {
                return;
            }
            if (!location.getChunk().isLoaded()) {
                return;
            }
            location.getWorld().spawnParticle(Particle.valueOf((String)particleName), location, amount.intValue(), offsetX.doubleValue(), offsetY.doubleValue(), offsetZ.doubleValue(), extra.doubleValue());
        }
    }

    static {
        RegisterManager.registerEffect(EffSpawnParticle.class, "([morkazsk ]|[mor.])(summon|play|create|activate|spawn) %number% [of] [particle] %string%:%number% offset (at|by|from) %number%, %number%(,| and) %number% at %location%", "([morkazsk ]|[mor.])(summon|play|create|activate|spawn) %number% [of] [particle] %string% offset (at|by|from) %number%, %number%(,| and) %number% with extra [data] %number% at %location%");
    }
}

