/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bson.Document;

@Name(value="Mongo Document Json")
@Description(value={"This expression allows to get the JSON content of a Mongo document."})
@Examples(value={"set {_document} to first document where \"points\" is \"10\" in {_collection}", "broadcast {_document}'s mongo json"})
@Since(value="1.0.1")
public class ExprDocumentJson
extends SimplePropertyExpression<Document, String> {
    public String convert(Document document) {
        return document.toJson();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    protected String getPropertyName() {
        return "mongo json";
    }

    static {
        ExprDocumentJson.register(ExprDocumentJson.class, String.class, (String)"mongo[db] json", (String)"mongodocuments");
    }
}

