/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.bson.Document;
import org.bukkit.event.Event;

@Name(value="Mongo Document")
@Description(value={"This expression allows you to retrieve a document according to a specific value from a specific collection."})
@Examples(value={"set {_client} to client named \"default\"", "set {_database} to database named \"mongosk\" with {_client}", "set {_collection} to collection named \"example\" from {_database}", "set {_document} to first document where \"points\" is \"10\" in {_collection}"})
@Since(value="1.0.0")
public class ExprDocument
extends SimpleExpression<Document> {
    private Expression<String> exprWhereName;
    private Expression<Object> exprWhereValue;
    private Expression<MongoCollection> exprCollection;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprWhereName = exprs[0];
        this.exprWhereValue = exprs[1];
        this.exprCollection = exprs[2];
        return true;
    }

    protected Document[] get(Event e) {
        Document[] documentArray;
        String whereName = (String)this.exprWhereName.getSingle(e);
        Object whereValue = this.exprWhereValue.getSingle(e);
        MongoCollection collection = (MongoCollection)this.exprCollection.getSingle(e);
        if (whereName == null || whereValue == null || collection == null) {
            return new Document[0];
        }
        Document document = (Document)collection.find(Filters.eq(whereName, whereValue)).first();
        if (document == null) {
            documentArray = new Document[]{};
        } else {
            Document[] documentArray2 = new Document[1];
            documentArray = documentArray2;
            documentArray2[0] = document;
        }
        return documentArray;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Document> getReturnType() {
        return Document.class;
    }

    public String toString(Event e, boolean debug) {
        return "first mongo document where " + this.exprWhereName.toString(e, debug) + " is " + this.exprWhereValue.toString(e, debug) + " of " + this.exprCollection.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprDocument.class, Document.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[first] [mongo[db]] document where %string% (is|equals to) %object% (of|in) %mongocollection%"});
    }
}

