/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import org.bukkit.event.Event;

@Name(value="Mongo Databases")
@Description(value={"This expression allows you to retrieve the names of the databases of a Mongo client."})
@Examples(value={"loop all databases from client named \"test\":", "\tbroadcast \"%loop-value\"", "", "set {_databases::*} to  all databases from client named \"test\""})
@Since(value="1.0.0")
public class ExprDatabases
extends SimpleExpression<String> {
    private Expression<MongoClient> exprClient;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprClient = exprs[0];
        return true;
    }

    protected String[] get(Event e) {
        MongoClient client = (MongoClient)this.exprClient.getSingle(e);
        if (client == null) {
            return new String[0];
        }
        ArrayList list = new ArrayList();
        client.listDatabaseNames().forEach(list::add);
        return list.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "all mongo databases from " + this.exprClient.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprDatabases.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] [mongo[db]] databases (of|from) %mongoclient%"});
    }
}

