/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.bukkit.event.Event;

@Name(value="Mongo Collections")
@Description(value={"This expression allows you to retrieve collection names from a Mongo database."})
@Examples(value={"loop all collections from database \"mongosk\" with client \"test\":", "\tbroadcast loop-value", "", "set {_collections::*} to all collections from database \"mongosk\" with client \"test\""})
@Since(value="1.0.0")
public class ExprCollections
extends SimpleExpression<String> {
    private Expression<MongoDatabase> exprDatabase;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprDatabase = exprs[0];
        return true;
    }

    protected String[] get(Event e) {
        MongoDatabase database = (MongoDatabase)this.exprDatabase.getSingle(e);
        if (database == null) {
            return new String[0];
        }
        ArrayList list = new ArrayList();
        database.listCollectionNames().forEach(list::add);
        return list.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "all mongo collections from " + this.exprDatabase.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCollections.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] [mongo[db]] collections [name[s]] (of|from) %mongodatabase%"});
    }
}

