/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.mongodb.client.MongoCollection;

@Name(value="Mongo Collection Document Count")
@Description(value={"This expression allows you to retrieve the number of documents in a Mongo collection."})
@Examples(value={"set {_collection} to collection named \"example\" from database named \"mongosk\" with client named \"default\"", "send \"%{_collection}'s document count%\""})
@Since(value="1.0.0")
public class ExprCollectionDocumentCount
extends SimplePropertyExpression<MongoCollection, Integer> {
    public Integer convert(MongoCollection collection) {
        return (int)collection.countDocuments();
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "document count";
    }

    static {
        ExprCollectionDocumentCount.register(ExprCollectionDocumentCount.class, Integer.class, (String)"[mongo[db]] document (count|size)", (String)"mongocollections");
    }
}

