/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bukkit.event.Event;

@Name(value="Mongo Collection")
@Description(value={"This expression allows you to retrieve a Mongo collection from a specific database."})
@Examples(value={"set {_client} to client named \"default\"", "set {_database} to database named \"mongosk\" with {_client}", "set {_collection} to collection named \"example\" from {_database}"})
@Since(value="1.0.0")
public class ExprCollection
extends SimpleExpression<MongoCollection> {
    private Expression<String> exprName;
    private Expression<MongoDatabase> exprDatabase;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprDatabase = exprs[1];
        return true;
    }

    protected MongoCollection[] get(Event e) {
        MongoCollection[] mongoCollectionArray;
        String name = (String)this.exprName.getSingle(e);
        MongoDatabase database = (MongoDatabase)this.exprDatabase.getSingle(e);
        if (name == null || database == null) {
            mongoCollectionArray = new MongoCollection[]{};
        } else {
            MongoCollection[] mongoCollectionArray2 = new MongoCollection[1];
            mongoCollectionArray = mongoCollectionArray2;
            mongoCollectionArray2[0] = database.getCollection(name);
        }
        return mongoCollectionArray;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends MongoCollection> getReturnType() {
        return MongoCollection.class;
    }

    public String toString(Event e, boolean debug) {
        return "mongo collection " + this.exprName.toString(e, debug) + " in " + this.exprDatabase.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCollection.class, MongoCollection.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[mongo[db]] collection [(named|with name|called)] %string% (in|of) %mongodatabase%"});
    }
}

