/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoClient;
import fr.romitou.mongosk.skript.MongoManager;
import org.bukkit.event.Event;

@Name(value="Mongo Client")
@Description(value={"This expression allows you to retrieve a Mongo client by name, initially defined in the creation effect."})
@Examples(value={"create a new mongo client to host \"mongodb://127.0.0.1\" as \"mongosk\"", "set {_client} to client named \"mongosk\""})
@Since(value="1.0.0")
public class ExprClient
extends SimpleExpression<MongoClient> {
    private Expression<String> exprName;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        return true;
    }

    protected MongoClient[] get(Event e) {
        MongoClient[] mongoClientArray;
        String name = (String)this.exprName.getSingle(e);
        if (name == null) {
            mongoClientArray = new MongoClient[]{};
        } else {
            MongoClient[] mongoClientArray2 = new MongoClient[1];
            mongoClientArray = mongoClientArray2;
            mongoClientArray2[0] = MongoManager.getClient(name);
        }
        return mongoClientArray;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends MongoClient> getReturnType() {
        return MongoClient.class;
    }

    public String toString(Event e, boolean debug) {
        return "mongo client named " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprClient.class, MongoClient.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[mongo[db]] client [of host] [(named|with name|called)] %string%"});
    }
}

