/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import fr.romitou.mongosk.MongoSK;
import fr.romitou.mongosk.skript.events.bukkit.DocumentSaveEvent;
import java.util.Arrays;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bukkit.event.Event;

@Name(value="Save Mongo Document")
@Description(value={"This effect allows you to save one or more documents in a Mongo collection. The document will be replaced by the new one if the identifier \"_id\" already exists. Otherwise it will be created."})
@Examples(value={"set {_collection} to collection named \"example\" of database \"mongosk\" with client \"test\"", "set {_doc} to document where \"player\" is \"Romitou\" in {_collection}", "set value \"points\" of {_doc} to 1", "save {_doc} in {_collection}"})
@Since(value="1.0.0")
public class EffSaveDocument
extends Effect {
    private Expression<Document> exprDocument;
    private Expression<MongoCollection> exprCollection;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprDocument = exprs[0];
        this.exprCollection = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Document[] document = (Document[])this.exprDocument.getArray(e);
        MongoCollection collection = (MongoCollection)this.exprCollection.getSingle(e);
        if (document.length == 0 || collection == null) {
            return;
        }
        Arrays.stream(document).forEach(doc -> {
            Bson filter = Filters.eq("_id", doc.get("_id"));
            if (collection.find(filter).first() == null) {
                collection.insertOne(doc);
            } else {
                collection.replaceOne(filter, doc);
            }
            MongoSK.getPluginManager().callEvent((Event)new DocumentSaveEvent((Document)doc));
        });
    }

    public String toString(Event e, boolean debug) {
        return "save mongo document " + this.exprDocument.toString(e, debug) + (this.exprCollection != null ? " in collection " + this.exprCollection.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffSaveDocument.class, (String[])new String[]{"save [mongo[db]] [document] %mongodocuments% (in|into) %mongocollection%"});
    }
}

