/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoDatabase;
import fr.romitou.mongosk.MongoSK;
import fr.romitou.mongosk.skript.events.bukkit.DatabaseDropEvent;
import org.bukkit.event.Event;

@Name(value="Drop Mongo Database")
@Description(value={"This effect allows you to delete a Mongo database. This action is irreversible! Disabled by default: go to the MongoSK configuration to enable this effect."})
@Examples(value={"drop without going back database named \"mongosk\" of client \"mongosk\""})
@Since(value="1.0.0")
public class EffDropDatabase
extends Effect {
    private Expression<MongoDatabase> exprDatabase;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprDatabase = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        if (!MongoSK.getConfigFile().getBoolean("allow-drop.databases")) {
            Skript.error((String)"You cannot delete a database. Go to the plugin configuration and enable the option, which was initially disabled for security reasons.");
            return;
        }
        MongoDatabase database = (MongoDatabase)this.exprDatabase.getSingle(e);
        if (database == null) {
            return;
        }
        database.drop();
        MongoSK.getPluginManager().callEvent((Event)new DatabaseDropEvent(database));
    }

    public String toString(Event e, boolean debug) {
        return "drop without going back " + this.exprDatabase.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDropDatabase.class, (String[])new String[]{"[mongo[db]] (drop|delete) without going back [the] %mongodatabase%"});
    }
}

