/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoCollection;
import fr.romitou.mongosk.MongoSK;
import fr.romitou.mongosk.skript.events.bukkit.CollectionDropEvent;
import org.bukkit.event.Event;

@Name(value="Drop Mongo Collection")
@Description(value={"This effect allows you to delete a Mongo collection. This action is irreversible! Disabled by default: go to the MongoSK configuration to enable this effect."})
@Examples(value={"set {_collection} to collection named \"example\" in database \"mongosk\" of client \"mongosk\"", "drop without going back {_collection}"})
@Since(value="1.0.0")
public class EffDropCollection
extends Effect {
    private Expression<MongoCollection> exprCollection;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprCollection = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        if (!MongoSK.getConfigFile().getBoolean("allow-drop.collections")) {
            Skript.error((String)"You cannot delete a collection. Go to the plugin configuration and enable the option, which was initially disabled for security reasons.");
            return;
        }
        MongoCollection collection = (MongoCollection)this.exprCollection.getSingle(e);
        if (collection == null) {
            return;
        }
        collection.drop();
        MongoSK.getPluginManager().callEvent((Event)new CollectionDropEvent(collection));
    }

    public String toString(Event e, boolean debug) {
        return "drop without going back " + this.exprCollection.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDropCollection.class, (String[])new String[]{"[mongo[db]] (drop|delete) without going back [the] %mongocollection%"});
    }
}

